/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexUtil;
import org.jetbrains.plugins.textmate.regex.Searcher;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.exception.JOniException;

public class RegexFacade {
    private static final Regex FAILED_REGEX = new Regex("^$", (Encoding)UTF8Encoding.INSTANCE);
    private static final Logger LOGGER = Logger.getInstance(RegexFacade.class);
    @NotNull
    private byte[] myRegexBytes;
    private Regex myRegex;

    private RegexFacade(@NotNull byte[] regexBytes) {
        if (regexBytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexBytes", "org/jetbrains/plugins/textmate/regex/RegexFacade", "<init>"));
        }
        this.myRegex = null;
        this.myRegexBytes = regexBytes;
    }

    public MatchData match(String string) {
        return this.match(string, 0);
    }

    public MatchData match(String string, int at) {
        byte[] stringBytes = string.getBytes(CharsetToolkit.UTF8_CHARSET);
        int byteOffset = RegexUtil.byteOffsetByCharOffset(string, at);
        Matcher matcher = this.getRegex().matcher(stringBytes, 0, stringBytes.length);
        int matchIndex = matcher.search(byteOffset, stringBytes.length, 256);
        return matchIndex > -1 ? MatchData.fromRegion(string, matcher.getEagerRegion()) : MatchData.NOT_MATCHED;
    }

    public Searcher searcher(String string) {
        byte[] stringBytes = string.getBytes(CharsetToolkit.UTF8_CHARSET);
        return new Searcher(string, stringBytes, this.getRegex().matcher(stringBytes, 0, stringBytes.length));
    }

    @NotNull
    private Regex getRegex() {
        if (this.myRegex == null) {
            try {
                this.myRegex = new Regex(this.myRegexBytes, 0, this.myRegexBytes.length, 256, (Encoding)UTF8Encoding.INSTANCE);
            }
            catch (JOniException e) {
                LOGGER.info("Failed to parse textmate regex", (Throwable)e);
                this.myRegex = FAILED_REGEX;
            }
            this.myRegexBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        Regex regex = this.myRegex;
        if (regex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/regex/RegexFacade", "getRegex"));
        }
        return regex;
    }

    @NotNull
    public static RegexFacade regex(@NotNull String regexString) {
        if (regexString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexString", "org/jetbrains/plugins/textmate/regex/RegexFacade", "regex"));
        }
        RegexFacade regexFacade = new RegexFacade(regexString.getBytes(CharsetToolkit.UTF8_CHARSET));
        if (regexFacade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/textmate/regex/RegexFacade", "regex"));
        }
        return regexFacade;
    }
}

