/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.lang.ejs.lexer.EjsFilterLexer;
import com.jetbrains.lang.ejs.lexer.EjsSimpleLexer;
import com.jetbrains.lang.ejs.lexer.EjsSmartIncludeLexer;
import com.jetbrains.lang.ejs.parsing.EjsParser;
import com.jetbrains.lang.ejs.psi.EjsFilterTokenTypes;
import com.jetbrains.lang.ejs.psi.EjsPsiFile;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import com.jetbrains.lang.ejs.util.EjsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjsParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        Lexer lexer = EjsParserDefinition.getLexer(project);
        if (lexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/EjsParserDefinition", "createLexer"));
        }
        return lexer;
    }

    public static Lexer getLexer(@Nullable Project project) {
        EjsSimpleLexer lexer = EjsSimpleLexer.buildFromDescriptions(EjsTokenTypes.OUTER_CONTENT, EjsTokenTypes.INNER_CONTENT, EjsTokenTypes.FILTER_CONTENT, EjsUtils.getOpenBracesInfo(project), EjsUtils.getFilterBraceInfo(project), EjsUtils.getCloseBraceInfo(project), EjsUtils.getCommentBraceInfo(project));
        lexer = new MergingLexerAdapter((Lexer)lexer, TokenSet.create((IElementType[])new IElementType[]{EjsTokenTypes.OUTER_CONTENT, EjsTokenTypes.INNER_CONTENT, EjsTokenTypes.FILTER_CONTENT}));
        LayeredLexer layeredLexer = new LayeredLexer((Lexer)lexer);
        layeredLexer.registerLayer((Lexer)new EjsSmartIncludeLexer(), new IElementType[]{EjsTokenTypes.INNER_CONTENT});
        layeredLexer.registerLayer((Lexer)new MergingLexerAdapter((Lexer)new EjsFilterLexer(), TokenSet.create((IElementType[])new IElementType[]{EjsFilterTokenTypes.EJS_RAW})), new IElementType[]{EjsTokenTypes.FILTER_CONTENT});
        return layeredLexer;
    }

    public PsiParser createParser(Project project) {
        return new EjsParser();
    }

    public IFileElementType getFileNodeType() {
        return EjsTokenTypes.EJS_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.WHITESPACE});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/EjsParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{EjsTokenTypes.BLOCK_COMMENT});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/EjsParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{EjsTokenTypes.FILE_PATH});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/EjsParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = EjsTokenTypes.FACTORY.createElement(node);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/EjsParserDefinition", "createElement"));
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new EjsPsiFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

