/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.ejs.EjsBundle;
import com.jetbrains.lang.ejs.EjsFilterParser;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EjsSimpleParser {
    private final Set<IElementType> myOpenBraces;
    private final IElementType myPairOfBracesElementType;
    private final IElementType myFilterElement;
    private final IElementType myCloseElement;

    public EjsSimpleParser(IElementType type, List<IElementType> openBraces, IElementType filterElement, IElementType closeElement) {
        this.myPairOfBracesElementType = type;
        this.myOpenBraces = new THashSet(openBraces);
        this.myFilterElement = filterElement;
        this.myCloseElement = closeElement;
    }

    public void parse(PsiBuilder builder) {
        while (!builder.eof()) {
            this.eatNonBraces(builder);
            IElementType elementType = builder.getTokenType();
            if (elementType == null) break;
            if (this.myOpenBraces.contains(elementType) || elementType == this.myFilterElement) {
                PsiBuilder.Marker pairOfBraces = builder.mark();
                EjsSimpleParser.parseLeafToken(builder, elementType);
                if (elementType == this.myFilterElement) {
                    PsiBuilder adaptedBuilder = GeneratedParserUtilBase.adapt_builder_((IElementType)EjsTokenTypes.FILTER_CONTENT, (PsiBuilder)builder, (PsiParser)new EjsFilterParser());
                    EjsFilterParser.chain(adaptedBuilder, 0);
                } else {
                    this.parseBraces(builder);
                }
                elementType = builder.getTokenType();
                if (elementType == null || elementType != this.myCloseElement) {
                    pairOfBraces.drop();
                    break;
                }
                EjsSimpleParser.parseLeafToken(builder, elementType);
                pairOfBraces.done(this.myPairOfBracesElementType);
                continue;
            }
            if (elementType != this.myCloseElement) continue;
            EjsSimpleParser.parseLeafToken(builder, elementType);
        }
    }

    private void parseBraces(PsiBuilder builder) {
        boolean hasImport = false;
        while (builder.getTokenType() != null && builder.getTokenType() != this.myCloseElement) {
            if (this.myOpenBraces.contains(builder.getTokenType())) {
                EjsSimpleParser.parseLeafToken(builder, builder.getTokenType());
                continue;
            }
            if (builder.getTokenType() == EjsTokenTypes.INCLUDE && !hasImport) {
                hasImport = EjsSimpleParser.parseImportStatement(builder);
                continue;
            }
            if (hasImport && (builder.getTokenType() == EjsTokenTypes.INCLUDE || builder.getTokenType() == EjsTokenTypes.FILE_PATH)) {
                PsiBuilder.Marker errorMark = builder.mark();
                builder.advanceLexer();
                errorMark.error(EjsBundle.message("ejs.parser.already.has.an.import.statement", new Object[0]));
                continue;
            }
            builder.advanceLexer();
        }
    }

    private static boolean parseImportStatement(PsiBuilder builder) {
        PsiBuilder.Marker importMark = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() != EjsTokenTypes.FILE_PATH) {
            importMark.drop();
            builder.error(EjsBundle.message("ejs.parser.file.path.expected", new Object[0]));
            return false;
        }
        PsiBuilder.Marker pathMark = builder.mark();
        builder.advanceLexer();
        pathMark.done((IElementType)EjsTokenTypes.FILE_PATH);
        importMark.done((IElementType)EjsTokenTypes.INCLUDE_STATEMENT);
        return true;
    }

    private static void parseLeafToken(PsiBuilder builder, IElementType leafTokenType) {
        PsiBuilder.Marker leafTokenMark = builder.mark();
        builder.advanceLexer();
        leafTokenMark.done(leafTokenType);
    }

    private void eatNonBraces(PsiBuilder builder) {
        EjsSimpleParser.eatUntil(builder, (Condition<IElementType>)((Condition)type -> this.myOpenBraces.contains(type) || type == this.myFilterElement || type == this.myCloseElement));
    }

    private static void eatUntil(@NotNull PsiBuilder builder, @NotNull Condition<IElementType> condition) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/lang/ejs/EjsSimpleParser", "eatUntil"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/jetbrains/lang/ejs/EjsSimpleParser", "eatUntil"));
        }
        while (builder.getTokenType() != null && !condition.value((Object)builder.getTokenType())) {
            builder.advanceLexer();
        }
    }
}

