/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.ejs.highlight.EjsSyntaxHighlighterColors;
import com.jetbrains.lang.ejs.psi.EjsPsiBraces;
import com.jetbrains.lang.ejs.psi.EjsPsiCloseBrace;
import com.jetbrains.lang.ejs.psi.EjsPsiOpenBrace;
import org.jetbrains.annotations.NotNull;

public class EjsColorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/ejs/annotator/EjsColorAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/lang/ejs/annotator/EjsColorAnnotator", "annotate"));
        }
        if (element instanceof EjsPsiBraces) {
            TextAttributesKey attributesKey;
            EjsPsiOpenBrace openBrace = ((EjsPsiBraces)element).getOpenBrace();
            EjsPsiCloseBrace closeBrace = ((EjsPsiBraces)element).getCloseBrace();
            IElementType openBraceTokenType = openBrace != null ? openBrace.getTokenType() : null;
            String colorKey = EjsSyntaxHighlighterColors.findBraceKeyByElementType(openBraceTokenType);
            TextAttributesKey textAttributesKey = attributesKey = colorKey != null ? TextAttributesKey.find((String)colorKey) : null;
            if (attributesKey != null && openBrace != null) {
                holder.createInfoAnnotation((PsiElement)openBrace, null).setTextAttributes(attributesKey);
            }
            if (attributesKey != null && closeBrace != null) {
                holder.createInfoAnnotation((PsiElement)closeBrace, null).setTextAttributes(attributesKey);
            }
        }
    }
}

