/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.config;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.ejs.EjsBundle;
import com.jetbrains.lang.ejs.util.EjsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjsConfigurable
implements SearchableConfigurable {
    private final Project myProject;
    private JPanel myMainPanel;
    private JTextField myOpenField;
    private JTextField myCloseField;

    public EjsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/ejs/config/EjsConfigurable", "<init>"));
        }
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    @NotNull
    public String getId() {
        if ("reference.settings.javascript.ejs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/config/EjsConfigurable", "getId"));
        }
        return "reference.settings.javascript.ejs";
    }

    @Nls
    public String getDisplayName() {
        return EjsBundle.message("ejs.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.javascript.ejs";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        Couple pair = Couple.of((Object)this.myOpenField.getText(), (Object)this.myCloseField.getText());
        return !pair.equals(EjsUtils.getDelimiters(this.myProject));
    }

    public void apply() throws ConfigurationException {
        String open = this.myOpenField.getText().trim();
        if (StringUtil.isEmpty((String)open)) {
            throw new ConfigurationException(EjsBundle.message("ejs.open.delimiter.is.empty", new Object[0]));
        }
        String close = this.myCloseField.getText().trim();
        if (StringUtil.isEmpty((String)close)) {
            throw new ConfigurationException(EjsBundle.message("ejs.close.delimiter.is.empty", new Object[0]));
        }
        EjsUtils.setDelimiters(this.myProject, open, close);
        EjsUtils.reparseProjectFiles(this.myProject);
    }

    public void reset() {
        Couple<String> delimiters = EjsUtils.getDelimiters(this.myProject);
        this.myOpenField.setText((String)delimiters.first);
        this.myCloseField.setText((String)delimiters.second);
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/jetbrains/lang/ejs/EjsBundle").getString("ejs.open.delimiter"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/jetbrains/lang/ejs/EjsBundle").getString("ejs.close.delimiter"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOpenField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(137, 28), null));
        this.myCloseField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(137, 28), null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

