/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.ejs.EjsLanguage;
import com.jetbrains.lang.ejs.file.EjsFileViewProvider;
import com.jetbrains.lang.ejs.psi.EjsPsiBraces;
import com.jetbrains.lang.ejs.psi.EjsPsiElement;
import com.jetbrains.lang.ejs.psi.EjsPsiOpenBrace;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import com.jetbrains.lang.ejs.util.EjsUtils;
import org.jetbrains.annotations.NotNull;

public class EjsTypedHandler
extends XmlGtTypedHandler {
    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile editedFile, FileType fileType) {
        FileViewProvider provider = editedFile.getViewProvider();
        if (!(provider instanceof EjsFileViewProvider)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        return super.beforeCharTyped(c, project, editor, editedFile, fileType);
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/ejs/editor/EjsTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/ejs/editor/EjsTypedHandler", "charTyped"));
        }
        FileViewProvider provider = file.getViewProvider();
        if (!(provider instanceof EjsFileViewProvider)) {
            return super.charTyped(c, project, editor, file);
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset > editor.getDocument().getTextLength()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Couple<String> delimiters = EjsUtils.getDelimiters(project);
        int openBraceLength = ((String)delimiters.first).length();
        if (offset < openBraceLength) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        String previousChars = editor.getDocument().getText(new TextRange(offset - openBraceLength, offset));
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        if (((String)delimiters.first).equals(previousChars) && !EjsTypedHandler.hasClosingBrace(project, editor, provider, offset - openBraceLength / 2)) {
            editor.getDocument().insertString(offset, (CharSequence)delimiters.second);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean hasClosingBrace(Project project, Editor editor, FileViewProvider provider, int offset) {
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        EjsPsiElement elementAt = (EjsPsiElement)PsiTreeUtil.getParentOfType((PsiElement)provider.findElementAt(offset, (Language)EjsLanguage.INSTANCE), EjsPsiElement.class);
        PsiElement parent = elementAt != null ? elementAt.getParent() : null;
        return parent instanceof EjsPsiBraces && ((EjsPsiBraces)parent).getOpenBrace() == elementAt && !EjsTypedHandler.containsUnbalancedOpenBrace((EjsPsiBraces)parent);
    }

    private static boolean containsUnbalancedOpenBrace(EjsPsiBraces braces) {
        EjsPsiOpenBrace currentChild = braces.getOpenBrace();
        if (currentChild == null) {
            return false;
        }
        while ((currentChild = currentChild.getNextSibling()) != null) {
            if (!(currentChild instanceof EjsPsiElement) || !EjsTokenTypes.OPEN_BRACES.contains(((EjsPsiElement)currentChild).getTokenType())) continue;
            return true;
        }
        return false;
    }
}

