/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.file;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.jetbrains.lang.ejs.EjsBundle;
import com.jetbrains.lang.ejs.EjsIcons;
import com.jetbrains.lang.ejs.EjsLanguage;
import com.jetbrains.lang.ejs.file.EjsTemplateHighlighter;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjsFileType
extends LanguageFileType
implements TemplateLanguageFileType {
    public static final LanguageFileType INSTANCE = new EjsFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "ejs";

    private EjsFileType() {
        super((Language)EjsLanguage.INSTANCE);
        FileTypeEditorHighlighterProviders.INSTANCE.addExplicitExtension((Object)this, (Object)new EditorHighlighterProvider(){

            public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme editorColorsScheme) {
                if (fileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/lang/ejs/file/EjsFileType$1", "getEditorHighlighter"));
                }
                if (editorColorsScheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorColorsScheme", "com/jetbrains/lang/ejs/file/EjsFileType$1", "getEditorHighlighter"));
                }
                return new EjsTemplateHighlighter(project, virtualFile, editorColorsScheme);
            }
        });
    }

    @NotNull
    public String getName() {
        String string = EjsBundle.message("ejs.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/file/EjsFileType", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = EjsBundle.message("ejs.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/file/EjsFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/file/EjsFileType", "getDefaultExtension"));
        }
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return EjsIcons.EJS;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/lang/ejs/file/EjsFileType", "extractCharsetFromFileContent"));
        }
        LanguageFileType associatedFileType = EjsFileType.getAssociatedFileType(file, project);
        if (associatedFileType == null) {
            return null;
        }
        return CharsetUtil.extractCharsetFromFileContent((Project)project, (VirtualFile)file, (FileType)associatedFileType, (CharSequence)content);
    }

    private static LanguageFileType getAssociatedFileType(VirtualFile file, Project project) {
        if (project == null) {
            return null;
        }
        Language language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(file);
        LanguageFileType associatedFileType = null;
        if (language != null) {
            associatedFileType = language.getAssociatedFileType();
        }
        if (language == null || associatedFileType == null) {
            associatedFileType = EjsLanguage.getDefaultTemplateLang();
        }
        return associatedFileType;
    }
}

