/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.file;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.ejs.EjsLanguage;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EjsFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    private final Language myTemplateDataLanguage;
    private static final TemplateDataElementType myTemplateDataElementType = new TemplateDataElementType("EJS_TEMPLATE_DATA", (Language)EjsLanguage.INSTANCE, EjsTokenTypes.OUTER_CONTENT, EjsTokenTypes.OUTER_TEMPLATE_ELEMENT);
    private static final EjsJavascriptTemplateDataElementType myJavaScriptTemplateDataElementType = new EjsJavascriptTemplateDataElementType();

    public EjsFileViewProvider(PsiManager manager, VirtualFile file, boolean physical) {
        this(manager, file, physical, EjsFileViewProvider.getTemplateDataLanguage(manager, file));
    }

    public EjsFileViewProvider(PsiManager manager, VirtualFile file, boolean physical, Language templateDataLanguage) {
        super(manager, file, physical);
        this.myTemplateDataLanguage = templateDataLanguage;
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootLanguage", "com/jetbrains/lang/ejs/file/EjsFileViewProvider", "supportsIncrementalReparse"));
        }
        return false;
    }

    private static Language getTemplateDataLanguage(PsiManager manager, VirtualFile file) {
        Language dataLang;
        TemplateDataLanguageMappings dataLanguageMappings = TemplateDataLanguageMappings.getInstance((Project)manager.getProject());
        Language language = dataLang = dataLanguageMappings != null ? dataLanguageMappings.getMapping(file) : null;
        if (dataLang == null) {
            dataLang = EjsLanguage.getDefaultTemplateLang().getLanguage();
        }
        Language substituteLang = LanguageSubstitutors.INSTANCE.substituteLanguage(dataLang, file, manager.getProject());
        if (TemplateDataLanguageMappings.getTemplateableLanguages().contains(substituteLang)) {
            dataLang = substituteLang;
        }
        return dataLang;
    }

    @NotNull
    public Language getBaseLanguage() {
        EjsLanguage ejsLanguage = EjsLanguage.INSTANCE;
        if (ejsLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/file/EjsFileViewProvider", "getBaseLanguage"));
        }
        return ejsLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/file/EjsFileViewProvider", "getTemplateDataLanguage"));
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        THashSet tHashSet = new THashSet(Arrays.asList(new Language[]{EjsLanguage.INSTANCE, JavascriptLanguage.INSTANCE, this.myTemplateDataLanguage}));
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/file/EjsFileViewProvider", "getLanguages"));
        }
        return tHashSet;
    }

    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(VirtualFile virtualFile) {
        return new EjsFileViewProvider(this.getManager(), virtualFile, false, this.myTemplateDataLanguage);
    }

    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/jetbrains/lang/ejs/file/EjsFileViewProvider", "createFile"));
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition == null) {
            return null;
        }
        if (lang == this.myTemplateDataLanguage) {
            PsiFileImpl file = (PsiFileImpl)parserDefinition.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)myTemplateDataElementType);
            return file;
        }
        if (lang == JavascriptLanguage.INSTANCE) {
            PsiFileImpl file = (PsiFileImpl)parserDefinition.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)myJavaScriptTemplateDataElementType);
            return file;
        }
        if (lang == EjsLanguage.INSTANCE) {
            return parserDefinition.createFile((FileViewProvider)this);
        }
        return null;
    }

    private static class EjsJavascriptTemplateDataElementType
    extends TemplateDataElementType {
        private static final Logger LOG = Logger.getInstance(EjsJavascriptTemplateDataElementType.class);
        private static final ThreadLocal<LinkedList<Integer>> ourOffsets = new ThreadLocal();

        protected LanguageFileType createTemplateFakeFileType(Language language) {
            return JavaScriptSupportLoader.JAVASCRIPT;
        }

        public EjsJavascriptTemplateDataElementType() {
            super("EJS_TEMPLATE_DATA", (Language)JavascriptLanguage.INSTANCE, EjsTokenTypes.INNER_CONTENT, EjsTokenTypes.INNER_TEMPLATE_ELEMENT);
        }

        protected CharSequence createTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull TemplateDataElementType.RangesCollector outerRangesCollector) {
            if (sourceCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceCode", "com/jetbrains/lang/ejs/file/EjsFileViewProvider$EjsJavascriptTemplateDataElementType", "createTemplateText"));
            }
            if (baseLexer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/jetbrains/lang/ejs/file/EjsFileViewProvider$EjsJavascriptTemplateDataElementType", "createTemplateText"));
            }
            if (outerRangesCollector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerRangesCollector", "com/jetbrains/lang/ejs/file/EjsFileViewProvider$EjsJavascriptTemplateDataElementType", "createTemplateText"));
            }
            ourOffsets.set(new LinkedList());
            return super.createTemplateText(sourceCode, baseLexer, outerRangesCollector);
        }

        protected void appendCurrentTemplateToken(StringBuilder result, CharSequence buf, Lexer lexer) {
            super.appendCurrentTemplateToken(result, buf, lexer);
            ourOffsets.get().add(result.length());
            int i = lexer.getTokenStart();
            char c = lexer.getBufferSequence().charAt(i);
            while (i >= 0 && c != '=' && c != '%') {
                c = lexer.getBufferSequence().charAt(--i);
            }
            if (c == '=') {
                result.append(";");
            } else {
                result.append("\n");
            }
        }

        protected void prepareParsedTemplateFile(final @NotNull FileElement root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/lang/ejs/file/EjsFileViewProvider$EjsJavascriptTemplateDataElementType", "prepareParsedTemplateFile"));
            }
            final LinkedList<Integer> offsets = ourOffsets.get();
            root.acceptTree((TreeElementVisitor)new RecursiveTreeElementVisitor(){
                private int shift = 0;

                protected boolean visitNode(TreeElement element) {
                    return true;
                }

                public void visitLeaf(LeafElement leaf) {
                    if (offsets.isEmpty() || this.shift + leaf.getTextOffset() + leaf.getTextLength() < (Integer)offsets.peekFirst()) {
                        return;
                    }
                    while (!offsets.isEmpty() && (Integer)offsets.peekFirst() < this.shift + leaf.getTextOffset()) {
                        offsets.pollFirst();
                    }
                    String newText = leaf.getText();
                    int localShift = 0;
                    while (!offsets.isEmpty() && (Integer)offsets.peekFirst() < this.shift + leaf.getTextOffset() + leaf.getTextLength()) {
                        int index = (Integer)offsets.pollFirst() - (this.shift + localShift + leaf.getTextOffset());
                        newText = this.removeChar(newText, index);
                        ++localShift;
                    }
                    this.shift += localShift;
                    if (!newText.isEmpty()) {
                        Object newAnchor = leaf instanceof PsiComment ? new PsiCommentImpl(((PsiComment)leaf).getTokenType(), (CharSequence)newText) : Factory.createSingleLeafElement((IElementType)leaf.getElementType(), (CharSequence)newText, (int)0, (int)newText.length(), null, (PsiManager)leaf.getManager());
                        if (leaf.getClass() != newAnchor.getClass()) {
                            LOG.warn("Bad leaf: " + leaf.getText() + " in \n" + root.getText());
                        }
                        leaf.rawInsertBeforeMe((TreeElement)newAnchor);
                    }
                    leaf.rawRemove();
                }

                private String removeChar(String text, int index) {
                    if (index < 0 || index >= text.length()) {
                        return text;
                    }
                    if (index == 0) {
                        return text.substring(1);
                    }
                    if (index == text.length() - 1) {
                        return text.substring(0, text.length() - 1);
                    }
                    return text.substring(0, index) + text.substring(index + 1);
                }
            });
            ourOffsets.set(null);
        }

        protected Language getTemplateFileLanguage(TemplateLanguageFileViewProvider viewProvider) {
            return this.getLanguage();
        }
    }
}

