/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.file;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.jetbrains.lang.ejs.EjsLanguage;
import com.jetbrains.lang.ejs.highlight.EjsHighlighter;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjsTemplateHighlighter
extends LayeredLexerEditorHighlighter {
    public EjsTemplateHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/jetbrains/lang/ejs/file/EjsTemplateHighlighter", "<init>"));
        }
        super((SyntaxHighlighter)new EjsHighlighter(project), colors);
        LanguageFileType type = null;
        if (project == null || virtualFile == null) {
            type = FileTypes.PLAIN_TEXT;
        } else {
            Language language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(virtualFile);
            if (language != null) {
                type = language.getAssociatedFileType();
            }
            if (type == null) {
                type = EjsLanguage.getDefaultTemplateLang();
            }
        }
        SyntaxHighlighter outerHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)type, (Project)project, (VirtualFile)virtualFile);
        SyntaxHighlighter innerHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)StdFileTypes.JS, (Project)project, (VirtualFile)virtualFile);
        this.registerLayer(EjsTokenTypes.OUTER_CONTENT, new LayerDescriptor(outerHighlighter, ""));
        this.registerLayer(EjsTokenTypes.INNER_CONTENT, new LayerDescriptor(innerHighlighter, ""));
    }
}

