/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.webcore.template.formatter.AbstractTemplateLanguageFormattingModelBuilder;
import com.intellij.webcore.template.formatter.TemplateLanguageBlock;
import com.jetbrains.lang.ejs.formatter.EjsFormattingModelBuilder;
import com.jetbrains.lang.ejs.formatter.settings.EjsCustomCodeStyleSettings;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjsBlock
extends TemplateLanguageBlock {
    private final EjsCustomCodeStyleSettings myCustomSettings;

    public EjsBlock(EjsFormattingModelBuilder builder, ASTNode node, Wrap wrap, Alignment alignment, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent) {
        super((AbstractTemplateLanguageFormattingModelBuilder)builder, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
        this.myCustomSettings = (EjsCustomCodeStyleSettings)settings.getCustomSettings(EjsCustomCodeStyleSettings.class);
    }

    public IElementType getElementType() {
        return this.myNode.getElementType();
    }

    @NotNull
    protected Indent getChildIndent(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/ejs/formatter/EjsBlock", "getChildIndent"));
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/formatter/EjsBlock", "getChildIndent"));
        }
        return indent;
    }

    protected Spacing getSpacing(TemplateLanguageBlock adjacentBlock) {
        return this.getSpacing((Block)this, (Block)adjacentBlock);
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/lang/ejs/formatter/EjsBlock", "getSpacing"));
        }
        if (child1 instanceof EjsBlock && EjsTokenTypes.OPEN_BRACES.contains(((EjsBlock)child1).getElementType())) {
            return this.getSpacingByBraceType(((EjsBlock)child1).getNode().getElementType());
        }
        if (child2 instanceof EjsBlock && ((EjsBlock)child2).getNode().getElementType() == EjsTokenTypes.CLOSE) {
            return this.getSpacingByBraceType(this.firstNodeElementType());
        }
        if (EjsBlock.ejsBlockWithType(child1, EjsTokenTypes.EJS_COLON)) {
            return this.creatSimpleSpaces(this.myCustomSettings.SPACES_AFTER_COLON);
        }
        if (EjsBlock.ejsBlockWithType(child2, EjsTokenTypes.EJS_COLON)) {
            return this.creatSimpleSpaces(this.myCustomSettings.SPACES_BEFORE_COLON);
        }
        if (EjsBlock.ejsBlockWithType(child1, EjsTokenTypes.EJS_OR) || EjsBlock.ejsBlockWithType(child2, EjsTokenTypes.EJS_OR)) {
            return this.creatSimpleSpaces(this.myCustomSettings.SPACES_WITHIN_CHAIN);
        }
        if (child1 instanceof EjsBlock && child2 instanceof EjsBlock) {
            return this.creatSimpleSpaces(true);
        }
        return null;
    }

    private static boolean ejsBlockWithType(Block block, IElementType expectedType) {
        return block instanceof EjsBlock && ((EjsBlock)block).getElementType() == expectedType;
    }

    private Spacing getSpacingByBraceType(@Nullable IElementType braceType) {
        return this.creatSimpleSpaces(this.myCustomSettings.needSpaces(braceType));
    }

    private Spacing creatSimpleSpaces(boolean spaces) {
        return Spacing.createSpacing((int)(spaces ? 1 : 0), (int)(spaces ? 1 : 0), (int)0, (boolean)this.getSettings().KEEP_LINE_BREAKS, (int)0);
    }

    protected void addBlocksForNonMarkupChild(List<Block> result, ASTNode child) {
        if (child.getElementType() == EjsTokenTypes.INNER_CONTENT) {
            PsiElement childPsi = child.getPsi();
            FormattingModelBuilder modelBuilder = LanguageFormatting.INSTANCE.forContext((Language)JavascriptLanguage.INSTANCE, childPsi);
            PsiFile jsPsiFile = childPsi.getContainingFile().getViewProvider().getPsi((Language)JavascriptLanguage.INSTANCE);
            if (modelBuilder != null && jsPsiFile != null) {
                FormattingModel childModel = modelBuilder.createModel((PsiElement)jsPsiFile, this.getSettings());
                result.add((Block)new InjectedLanguageBlockWrapper(childModel.getRootBlock(), child.getStartOffset(), child.getTextRange(), Indent.getNoneIndent()));
            }
        } else {
            super.addBlocksForNonMarkupChild(result, child);
        }
    }

    public boolean startsWithEQ() {
        IElementType nodeElementType = this.firstNodeElementType();
        return nodeElementType == EjsTokenTypes.OPEN_EQ || nodeElementType == EjsTokenTypes.OPEN_EQ_EQ || nodeElementType == EjsTokenTypes.OPEN_EQ_GENERATOR || nodeElementType == EjsTokenTypes.OPEN_FILTER;
    }

    @Nullable
    private IElementType firstNodeElementType() {
        ASTNode node = this.myNode.getFirstChildNode();
        return node != null ? node.getElementType() : null;
    }
}

