/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.webcore.template.formatter.AbstractTemplateLanguageFormattingModelBuilder;
import com.intellij.webcore.template.formatter.TemplateXmlTagBlock;
import com.jetbrains.lang.ejs.formatter.EjsBlock;
import com.jetbrains.lang.ejs.formatter.EjsSyntheticBlock;
import com.jetbrains.lang.ejs.psi.EjsPsiFile;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjsFormattingModelBuilder
extends AbstractTemplateLanguageFormattingModelBuilder {
    protected boolean isTemplateFile(PsiFile file) {
        return file instanceof EjsPsiFile;
    }

    public boolean isOuterLanguageElement(PsiElement element) {
        IElementType elementType = element.getNode().getElementType();
        return elementType == EjsTokenTypes.OUTER_TEMPLATE_ELEMENT;
    }

    public boolean isMarkupLanguageElement(PsiElement element) {
        return element.getNode().getElementType() == EjsTokenTypes.OUTER_CONTENT;
    }

    protected Block createTemplateLanguageBlock(ASTNode node, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        return new EjsBlock(this, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
    }

    protected XmlTagBlock createXmlTagBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent) {
        return new EjsTemplateXmlTagBlock(node, wrap, alignment, policy, indent);
    }

    protected SyntheticBlock createSyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
        return new EjsSyntheticBlock(subBlocks, parent, indent, policy, childIndent);
    }

    private class EjsTemplateXmlTagBlock
    extends TemplateXmlTagBlock {
        public EjsTemplateXmlTagBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent) {
            super((AbstractTemplateLanguageFormattingModelBuilder)EjsFormattingModelBuilder.this, node, wrap, alignment, policy, indent);
        }

        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            EjsBlock block;
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/lang/ejs/formatter/EjsFormattingModelBuilder$EjsTemplateXmlTagBlock", "getSpacing"));
            }
            if (child1 instanceof EjsSyntheticBlock && ((EjsSyntheticBlock)child1).endsWithEjsBlock() && (block = (EjsBlock)((EjsSyntheticBlock)child1).lastBlock()) != null && !block.startsWithEQ()) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)1);
            }
            if (child2 instanceof EjsSyntheticBlock && ((EjsSyntheticBlock)child2).startsWithEjsBlock() && (block = (EjsBlock)((EjsSyntheticBlock)child2).firstBlock()) != null && !block.startsWithEQ()) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)1);
            }
            return super.getSpacing(child1, child2);
        }
    }
}

