/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.formatter.settings;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.lang.ejs.EjsBundle;
import com.jetbrains.lang.ejs.EjsLanguage;
import com.jetbrains.lang.ejs.formatter.settings.EjsCustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class EjsLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public static final String SPACING_CODE_SAMPLE = "<%# all syntax features %>\n<% if (title) { %>\n    <h1><%= title %></h1>\n<% } %>\n<p><%=: users | map:'name' | join %></p>\n<ul>\n    <li>Escaped value <%= value %></li>\n    <li>Unescaped value <%== value %></li>\n    <li>Generated escaped tag <%%= value %></li>\n</ul>";

    @NotNull
    public Language getLanguage() {
        EjsLanguage ejsLanguage = EjsLanguage.INSTANCE;
        if (ejsLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/formatter/settings/EjsLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return ejsLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/jetbrains/lang/ejs/formatter/settings/EjsLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS ? SPACING_CODE_SAMPLE : null;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/ejs/formatter/settings/EjsLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/jetbrains/lang/ejs/formatter/settings/EjsLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        super.customizeSettings(consumer, settingsType);
        if (settingsType != LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            return;
        }
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_BRACES", EjsBundle.message("ejs.style.spaces.within.braces", new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_EQ_BRACES", EjsBundle.message("ejs.style.spaces.within.eq.braces", new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_EQ_EQ_BRACES", EjsBundle.message("ejs.style.spaces.within.eq.eq.braces", new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_EQ_GENERATE_BRACES", EjsBundle.message("ejs.style.spaces.within.eq.generate.braces", new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_FILTER", EjsBundle.message("ejs.style.spaces.within.filter.braces", new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_BEFORE_COLON", EjsBundle.message("ejs.style.spaces.before.colon", new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_AFTER_COLON", EjsBundle.message("ejs.style.spaces.after.colon", new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_CHAIN", EjsBundle.message("ejs.style.spaces.within.chain", new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
    }
}

