/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.highlight;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.ejs.EjsParserDefinition;
import com.jetbrains.lang.ejs.highlight.EjsSyntaxHighlighterColors;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjsHighlighter
extends SyntaxHighlighterBase {
    private final Project myProject;

    public EjsHighlighter(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        Lexer lexer = EjsParserDefinition.getLexer(this.myProject);
        if (lexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/highlight/EjsHighlighter", "getHighlightingLexer"));
        }
        return lexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType == EjsTokenTypes.BLOCK_COMMENT) {
            TextAttributesKey[] textAttributesKeyArray = EjsHighlighter.pack((TextAttributesKey)EjsSyntaxHighlighterColors.BLOCK_COMMENT);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/highlight/EjsHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (tokenType == EjsTokenTypes.INCLUDE) {
            TextAttributesKey[] textAttributesKeyArray = EjsHighlighter.pack((TextAttributesKey)EjsSyntaxHighlighterColors.INCLUDE);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/highlight/EjsHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (tokenType == EjsTokenTypes.FILE_PATH) {
            TextAttributesKey[] textAttributesKeyArray = EjsHighlighter.pack((TextAttributesKey)EjsSyntaxHighlighterColors.FILE_PATH);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/highlight/EjsHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/highlight/EjsHighlighter", "getTokenHighlights"));
        }
        return EMPTY;
    }
}

