/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.ejs.EjsBundle;
import com.jetbrains.lang.ejs.psi.EjsPsiFilePath;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjsUnresolvedIncludeInspection
extends LocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = EjsBundle.message("inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/inspections/EjsUnresolvedIncludeInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjsBundle.message("inspections.unresolved.include.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/inspections/EjsUnresolvedIncludeInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("EjsUnresolvedInclude" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/ejs/inspections/EjsUnresolvedIncludeInspection", "getShortName"));
        }
        return "EjsUnresolvedInclude";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/ejs/inspections/EjsUnresolvedIncludeInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/lang/ejs/inspections/EjsUnresolvedIncludeInspection", "checkFile"));
        }
        final ArrayList result = new ArrayList();
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof EjsPsiFilePath) {
                    for (PsiReference reference : element.getReferences()) {
                        if (!(reference instanceof FileReference) || reference.resolve() != null) continue;
                        result.add(manager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), EjsUnresolvedIncludeInspection.this.getDisplayName(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, ((FileReference)reference).getQuickFixes()));
                    }
                }
                super.visitElement(element);
            }
        });
        return result.isEmpty() ? super.checkFile(file, manager, isOnTheFly) : (ProblemDescriptor[])ArrayUtil.toObjectArray(result, ProblemDescriptor.class);
    }
}

