/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.lexer;

import com.intellij.ide.highlighter.custom.AbstractCustomLexer;
import com.intellij.ide.highlighter.custom.tokens.BraceTokenParser;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EjsSimpleLexer
extends AbstractCustomLexer {
    private static final int DEFAULT_STATE = 0;
    private static final int INSIDE_BRACES_STATE = 1;
    private static final int INSIDE_FILTER_STATE = 2;
    private final Set<IElementType> myOpenBraces;
    private final IElementType myFilterBrace;
    private final IElementType myCloseBrace;
    private final IElementType myCommentBrace;
    protected final IElementType myOuterElementType;
    protected final IElementType myInnerElementType;
    protected final IElementType myFilterElementType;
    protected int myState;

    public static EjsSimpleLexer buildFromDescriptions(@NotNull IElementType outerElementType, @NotNull IElementType innerElementType, @NotNull IElementType filterElementType, List<Pair<String, IElementType>> openBracesList, Pair<String, IElementType> filterBraceInfo, Pair<String, IElementType> closeBraceInfo, Pair<String, IElementType> commentBraceInfo) {
        if (outerElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerElementType", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "buildFromDescriptions"));
        }
        if (innerElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerElementType", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "buildFromDescriptions"));
        }
        if (filterElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterElementType", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "buildFromDescriptions"));
        }
        ArrayList<TokenParser> tokenParsers = new ArrayList<TokenParser>(openBracesList.size() + 1);
        THashSet openBraces = new THashSet(openBracesList.size());
        tokenParsers.add((TokenParser)new BraceTokenParser((String)commentBraceInfo.first, (IElementType)commentBraceInfo.second));
        tokenParsers.add((TokenParser)new BraceTokenParser((String)filterBraceInfo.first, (IElementType)filterBraceInfo.second));
        for (Pair<String, IElementType> openBraceDescription : openBracesList) {
            tokenParsers.add((TokenParser)new BraceTokenParser((String)openBraceDescription.first, (IElementType)openBraceDescription.second));
            openBraces.add(openBraceDescription.getSecond());
        }
        tokenParsers.add((TokenParser)new BraceTokenParser((String)closeBraceInfo.first, (IElementType)closeBraceInfo.second));
        return new EjsSimpleLexer(outerElementType, innerElementType, filterElementType, tokenParsers, (Set<IElementType>)openBraces, (IElementType)filterBraceInfo.second, (IElementType)closeBraceInfo.second, (IElementType)commentBraceInfo.second);
    }

    protected EjsSimpleLexer(@NotNull IElementType outerElementType, @NotNull IElementType innerElementType, @NotNull IElementType filterElementType, List<TokenParser> parsers, Set<IElementType> openBraces, @NotNull IElementType filterBrace, @NotNull IElementType closeBrace, @NotNull IElementType commentBrace) {
        if (outerElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerElementType", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "<init>"));
        }
        if (innerElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerElementType", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "<init>"));
        }
        if (filterElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterElementType", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "<init>"));
        }
        if (filterBrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterBrace", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "<init>"));
        }
        if (closeBrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeBrace", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "<init>"));
        }
        if (commentBrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentBrace", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "<init>"));
        }
        super(parsers);
        this.myState = 0;
        this.myOuterElementType = outerElementType;
        this.myInnerElementType = innerElementType;
        this.myFilterElementType = filterElementType;
        this.myOpenBraces = openBraces;
        this.myFilterBrace = filterBrace;
        this.myCloseBrace = closeBrace;
        this.myCommentBrace = commentBrace;
    }

    public void advance() {
        IElementType elementType = this.getTokenType();
        if (elementType != null && this.myCloseBrace == elementType) {
            this.myState = 0;
        }
        super.advance();
        elementType = this.getTokenType();
        if (elementType != null && this.myOpenBraces.contains(elementType)) {
            this.myState = 1;
        }
        if (elementType != null && elementType == this.myFilterBrace) {
            this.myState = 2;
        }
        if (this.myCommentBrace == elementType) {
            int start = this.getTokenStart();
            do {
                super.advance();
            } while (this.getTokenType() != null && this.getTokenType() != this.myCloseBrace);
            this.myCurrentToken.updateData(start, this.myCurrentToken.getEnd(), this.myCommentBrace);
        }
    }

    protected void handleTokenNotFound() {
        IElementType elementType;
        switch (this.myState) {
            case 1: {
                elementType = this.myInnerElementType;
                break;
            }
            case 2: {
                elementType = this.myFilterElementType;
                break;
            }
            default: {
                elementType = this.myOuterElementType;
            }
        }
        this.myCurrentToken.updateData(this.myPosition, this.myPosition + 1, elementType);
    }

    public int getState() {
        return this.myState;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/lang/ejs/lexer/EjsSimpleLexer", "start"));
        }
        this.myState = initialState;
        super.start(buffer, startOffset, endOffset, initialState);
    }
}

