/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.lang.ejs.EjsLanguage;
import com.jetbrains.lang.ejs.psi.EjsElementType;
import com.jetbrains.lang.ejs.psi.impl.EjsPsiBracesImpl;
import com.jetbrains.lang.ejs.psi.impl.EjsPsiCloseBraceImpl;
import com.jetbrains.lang.ejs.psi.impl.EjsPsiElementImpl;
import com.jetbrains.lang.ejs.psi.impl.EjsPsiFilePathImpl;
import com.jetbrains.lang.ejs.psi.impl.EjsPsiIncludeStatementImpl;
import com.jetbrains.lang.ejs.psi.impl.EjsPsiOpenBraceImpl;

public class EjsTokenTypes {
    public static final IFileElementType EJS_FILE = new IStubFileElementType("EJS_FILE", (Language)EjsLanguage.INSTANCE);
    public static final EjsElementType BLOCK_COMMENT = new EjsElementType("BLOCK_COMMENT");
    public static final IElementType INNER_CONTENT = new EjsElementType("INNER_CONTENT");
    public static final IElementType OUTER_CONTENT = new EjsElementType("OUTER_CONTENT");
    public static final IElementType FILTER_CONTENT = new EjsElementType("FILTER_CONTENT");
    public static final IElementType INNER_TEMPLATE_ELEMENT = new EjsElementType("INNER_TEMPLATE_ELEMENT");
    public static final IElementType OUTER_TEMPLATE_ELEMENT = new EjsElementType("OUTER_TEMPLATE_ELEMENT");
    public static final IElementType PAIR_OF_BRACES = new EjsElementType("PAIR_OF_BRACES");
    public static final EjsElementType OPEN = new EjsElementType("OPEN");
    public static final EjsElementType OPEN_EQ = new EjsElementType("OPEN_EQ");
    public static final EjsElementType OPEN_EQ_EQ = new EjsElementType("OPEN_EQ_EQ");
    public static final EjsElementType OPEN_EQ_GENERATOR = new EjsElementType("OPEN_EQ_GENERATOR");
    public static final EjsElementType OPEN_FILTER = new EjsElementType("OPEN_FILTER");
    public static final EjsElementType INCLUDE_STATEMENT = new EjsElementType("INCLUDE_STATEMENT");
    public static final EjsElementType INCLUDE = new EjsElementType("INCLUDE");
    public static final EjsElementType FILE_PATH = new EjsElementType("FILE_PATH");
    public static final TokenSet OPEN_BRACES = TokenSet.create((IElementType[])new IElementType[]{OPEN, OPEN_EQ, OPEN_EQ_EQ, OPEN_EQ_GENERATOR, OPEN_FILTER});
    public static final IElementType CLOSE = new EjsElementType("CLOSE");
    private static final String COLON_TOKEN = ":";
    public static final IElementType EJS_COLON = new EjsElementType(":");
    private static final String COMMA_TOKEN = ",";
    public static final IElementType EJS_COMMA = new EjsElementType(",");
    private static final String OR_TOKEN = "|";
    public static final IElementType EJS_OR = new EjsElementType("|");
    public static final IElementType EJS_RAW = new EjsElementType("RAW");

    public static class FACTORY {
        public static IElementType getType(String token) {
            if (EjsTokenTypes.COLON_TOKEN.equals(token)) {
                return EJS_COLON;
            }
            if (EjsTokenTypes.COMMA_TOKEN.equals(token)) {
                return EJS_COMMA;
            }
            if (EjsTokenTypes.OR_TOKEN.equals(token)) {
                return EJS_OR;
            }
            if ("CLOSE".equals(token)) {
                return CLOSE;
            }
            return EJS_RAW;
        }

        public static PsiElement createElement(ASTNode node) {
            IElementType elementType = node.getElementType();
            if (elementType == PAIR_OF_BRACES) {
                return new EjsPsiBracesImpl(node);
            }
            if (elementType == FILE_PATH) {
                return new EjsPsiFilePathImpl(node);
            }
            if (elementType == CLOSE) {
                return new EjsPsiCloseBraceImpl(node);
            }
            if (elementType == INCLUDE_STATEMENT) {
                return new EjsPsiIncludeStatementImpl(node);
            }
            if (OPEN_BRACES.contains(elementType)) {
                return new EjsPsiOpenBraceImpl(node);
            }
            return new EjsPsiElementImpl(node);
        }
    }
}

