/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack.lang;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.tasks.youtrack.YouTrackIntellisense;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YouTrackHighlightingAnnotator
extends ExternalAnnotator<QueryInfo, List<YouTrackIntellisense.HighlightRange>> {
    private static Logger LOG = Logger.getInstance(YouTrackHighlightingAnnotator.class);

    @Nullable
    public QueryInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/tasks/youtrack/lang/YouTrackHighlightingAnnotator", "collectInformation"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/tasks/youtrack/lang/YouTrackHighlightingAnnotator", "collectInformation"));
        }
        YouTrackIntellisense intellisense = (YouTrackIntellisense)file.getUserData(YouTrackIntellisense.INTELLISENSE_KEY);
        if (intellisense == null || !intellisense.getRepository().isConfigured()) {
            return null;
        }
        String text = file.getText();
        int offset = editor.getCaretModel().getOffset();
        return new QueryInfo(offset, text, intellisense);
    }

    @Nullable
    public List<YouTrackIntellisense.HighlightRange> doAnnotate(QueryInfo collectedInfo) {
        if (collectedInfo == null) {
            return Collections.emptyList();
        }
        String query = collectedInfo.myText;
        int offset = collectedInfo.myCaretOffset;
        try {
            return collectedInfo.myIntellisense.fetchHighlighting(query, offset);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public void apply(@NotNull PsiFile file, List<YouTrackIntellisense.HighlightRange> ranges, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/tasks/youtrack/lang/YouTrackHighlightingAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/tasks/youtrack/lang/YouTrackHighlightingAnnotator", "apply"));
        }
        for (YouTrackIntellisense.HighlightRange range : ranges) {
            if (range.getStyleClass().equals("error")) {
                holder.createErrorAnnotation(range.getTextRange(), null);
                continue;
            }
            Annotation infoAnnotation = holder.createInfoAnnotation(range.getTextRange(), null);
            infoAnnotation.setEnforcedTextAttributes(range.getTextAttributes());
        }
    }

    public static class QueryInfo {
        private final int myCaretOffset;
        private final String myText;
        private final YouTrackIntellisense myIntellisense;

        private QueryInfo(int caretOffset, String text, YouTrackIntellisense repository) {
            this.myCaretOffset = caretOffset;
            this.myText = text;
            this.myIntellisense = repository;
        }
    }
}

