/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorFacade {
    private static final MeteorFacade instance = new MeteorFacade();

    public static MeteorFacade getInstance() {
        return instance;
    }

    public boolean isMeteorFolder(String path) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !"enable".equals(System.getProperty("meteor.js"))) {
            return false;
        }
        String normalizedPath = FileUtil.toCanonicalPath((String)path);
        File file = new File(normalizedPath);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        int i = ArrayUtil.find((Object[])file.list(), (Object)".meteor");
        return i != -1;
    }

    @NotNull
    public Collection<VirtualFile> getMeteorFolders(Project project) {
        List list = ContainerUtil.filter((Collection)FilenameIndex.getVirtualFilesByName((Project)project, (String)".meteor", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)), file -> !JSLibraryUtil.isProbableLibraryFile((VirtualFile)file) && file.isDirectory());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/MeteorFacade", "getMeteorFolders"));
        }
        return list;
    }

    public boolean isMeteorProject(@Nullable Project project) {
        if (project == null || project.isDefault() || project.isDisposed()) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !"enable".equals(System.getProperty("meteor.js"))) {
            return false;
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean("js.meteor.project");
    }

    boolean hasMeteorFolders(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        return !this.getMeteorFolders(project).isEmpty();
    }

    public void setIsMeteorProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/MeteorFacade", "setIsMeteorProject"));
        }
        PropertiesComponent.getInstance((Project)project).setValue("js.meteor.project", true);
    }
}

