/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor;

import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.jetbrains.plugins.meteor.MeteorFacade;
import com.jetbrains.plugins.meteor.tsStubs.MeteorStubPath;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MeteorJSPredefinedLibraryProvider
extends JSPredefinedLibraryProvider {
    private static volatile SoftReference<VirtualFile> stubFile = null;

    public static void resetFile() {
        stubFile = null;
    }

    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/MeteorJSPredefinedLibraryProvider", "getPredefinedLibraries"));
        }
        if (!MeteorFacade.getInstance().isMeteorProject(project)) {
            if (ScriptingLibraryModel.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/MeteorJSPredefinedLibraryProvider", "getPredefinedLibraries"));
            }
            return ScriptingLibraryModel.EMPTY_ARRAY;
        }
        Set<VirtualFile> libFiles = MeteorJSPredefinedLibraryProvider.getLibraryFiles();
        ScriptingLibraryModel libraryModel = ScriptingLibraryModel.createPredefinedLibrary((String)"Meteor project library", (VirtualFile[])VfsUtilCore.toVirtualFileArray(libFiles), (String)"http://docs.meteor.com", (boolean)false);
        ScriptingLibraryModel[] scriptingLibraryModelArray = new ScriptingLibraryModel[]{libraryModel};
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/MeteorJSPredefinedLibraryProvider", "getPredefinedLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    @NotNull
    private static Set<VirtualFile> getLibraryFiles() {
        VirtualFile file = (VirtualFile)SoftReference.dereference(stubFile);
        if (file == null) {
            file = MeteorStubPath.getLasMeteorLib();
            stubFile = new SoftReference((Object)file);
        }
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new VirtualFile[]{file});
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/MeteorJSPredefinedLibraryProvider", "getLibraryFiles"));
        }
        return hashSet;
    }
}

