/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor;

import com.dmarcotte.handlebars.config.HbConfig;
import com.intellij.ProjectTopics;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.jetbrains.plugins.meteor.MeteorFacade;
import com.jetbrains.plugins.meteor.MeteorJSPredefinedLibraryProvider;
import com.jetbrains.plugins.meteor.ide.action.MeteorAutoImportProcessor;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import com.jetbrains.plugins.meteor.tsStubs.MeteorStubPath;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MeteorProjectComponent
extends AbstractProjectComponent {
    public static final String METEOR_FOLDER = ".meteor";
    public static final String METEOR_LOCAL_FOLDER = "local";
    public static final String METEOR_RELATIVE_PATH_TO_LOCAL_FOLDER = ".meteor/local";
    public static final String METEOR_LIBRARY_NAME = "Meteor project library";
    public static final String JS_METEOR_LIBRARY_WAS_ENABLED = "js.meteor.library.was.enabled";
    public static final String METEOR_PROJECT_KEY = "js.meteor.project";
    private final MergingUpdateQueue myQueue;
    private final Object myIdentity = new Object();

    private synchronized MeteorAutoImportProcessor getPackageUpdater() {
        return MeteorAutoImportProcessor.get(this.myProject);
    }

    protected MeteorProjectComponent(Project project) {
        super(project);
        this.myQueue = new MergingUpdateQueue("Meteor update status", 1000, true, null, (Disposable)project, null, true);
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                MeteorProjectComponent.this.myQueue.queue(MeteorProjectComponent.this.getFindMeteorRootsUpdate());
            }
        });
    }

    @NotNull
    private Update getFindMeteorRootsUpdate() {
        Update update = new Update(this.myIdentity){

            public void run() {
                DumbService.getInstance((Project)MeteorProjectComponent.this.myProject).smartInvokeLater(() -> MeteorProjectComponent.this.findMeteorRoots());
            }
        };
        if (update == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/MeteorProjectComponent", "getFindMeteorRootsUpdate"));
        }
        return update;
    }

    public static MeteorProjectComponent getInstance(Project project) {
        return (MeteorProjectComponent)((Object)project.getComponent(MeteorProjectComponent.class));
    }

    public void initComponent() {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.isMeteorProject()) {
                MeteorAutoImportProcessor.get(this.myProject).update();
            }
            this.myQueue.queue(this.getFindMeteorRootsUpdate());
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/meteor/MeteorProjectComponent$3", "fileCreated"));
                }
                MeteorProjectComponent.this.updatePackagesIfNeed(event);
                if (!event.getFileName().equals(MeteorProjectComponent.METEOR_FOLDER) || !MeteorSettings.getInstance().isExcludeMeteorLocalFolder()) {
                    return;
                }
                MeteorProjectComponent.this.updateModuleExcludeByFSEvent(event, ContainerUtil.newHashSet(), ContainerUtil.newHashSet((Object[])new String[]{MeteorProjectComponent.getExcludedFolderName(event)}));
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/meteor/MeteorProjectComponent$3", "beforeFileDeletion"));
                }
                if (!event.getFileName().equals(MeteorProjectComponent.METEOR_FOLDER)) {
                    return;
                }
                MeteorProjectComponent.this.updateModuleExcludeByFSEvent(event, ContainerUtil.newHashSet((Object[])new String[]{MeteorProjectComponent.getExcludedFolderName(event)}), ContainerUtil.newHashSet());
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/meteor/MeteorProjectComponent$3", "contentsChanged"));
                }
                MeteorProjectComponent.this.updatePackagesIfNeed(event);
            }
        }, (Disposable)this.myProject);
    }

    private void updatePackagesIfNeed(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/meteor/MeteorProjectComponent", "updatePackagesIfNeed"));
        }
        if (!event.getFileName().equals("versions") || !this.isMeteorProject()) {
            return;
        }
        this.getPackageUpdater().update();
    }

    public void findMeteorRoots() {
        if (this.myProject.isDisposed()) {
            return;
        }
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            boolean shouldUpdateFileTypes;
            if (!this.isMeteorProject() && (MeteorFacade.getInstance().hasMeteorFolders(this.myProject) || this.projectHasExcludedMeteorFolder())) {
                MeteorFacade.getInstance().setIsMeteorProject(this.myProject);
                shouldUpdateFileTypes = true;
            } else {
                shouldUpdateFileTypes = false;
            }
            if (!this.isMeteorProject()) {
                return;
            }
            MeteorProjectComponent.initMeteorProject(this.myProject, shouldUpdateFileTypes);
        }
        finally {
            token.finish();
        }
    }

    public static void initMeteorProject(Project project, boolean shouldUpdateFileTypes) {
        MeteorProjectComponent.attachPredefinedMeteorLibrary(project);
        boolean bl = shouldUpdateFileTypes = MeteorProjectComponent.setDefaultForShouldOpenHtmlAsHandlebars(project) || shouldUpdateFileTypes;
        if (MeteorSettings.getInstance().isExcludeMeteorLocalFolder()) {
            MeteorProjectComponent.excludeLocalMeteorFolders(project);
        }
        if (shouldUpdateFileTypes) {
            MeteorProjectComponent.updateFileTypesAfterChanges();
            MeteorAutoImportProcessor.get(project).update();
        }
    }

    private static void updateFileTypesAfterChanges() {
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> FileTypeManagerEx.getInstanceEx().fireFileTypesChanged()));
    }

    private boolean isMeteorProject() {
        return MeteorFacade.getInstance().isMeteorProject(this.myProject);
    }

    public static boolean setDefaultForShouldOpenHtmlAsHandlebars(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/MeteorProjectComponent", "setDefaultForShouldOpenHtmlAsHandlebars"));
        }
        if (StringUtil.isEmpty((String)HbConfig.getRawOpenHtmlAsHandlebarsValue((Project)project))) {
            HbConfig.setShouldOpenHtmlAsHandlebars((boolean)true, (Project)project);
            return true;
        }
        return false;
    }

    private static void attachPredefinedMeteorLibrary(Project project) {
        if (!MeteorProjectComponent.isMeteorLibraryWasEnabled(project)) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                JSLibraryManager libraryManager = JSLibraryManager.getInstance((Project)project);
                libraryManager.commitChanges();
                libraryManager.getLibraryMappings().associate(null, METEOR_LIBRARY_NAME, true);
                MeteorProjectComponent.setMeteorLibraryWasEnabled(project);
                MeteorProjectComponent.updateLibrariesFiles(project);
            });
        } else {
            MeteorProjectComponent.updateLibrariesFiles(project);
        }
    }

    private static void updateLibrariesFiles(Project project) {
        if (project.isDisposed()) {
            return;
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance((Project)project);
        MeteorStubPath.getStubDir().refresh(true, true, () -> {
            if (project.isDisposed()) {
                return;
            }
            ScriptingLibraryModel model = libraryManager.getLibraryByName(METEOR_LIBRARY_NAME);
            VirtualFile meteorLib = MeteorStubPath.getLasMeteorLib();
            if (model != null && !model.containsFile(meteorLib)) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    MeteorJSPredefinedLibraryProvider.resetFile();
                    libraryManager.updateLibrary(METEOR_LIBRARY_NAME, METEOR_LIBRARY_NAME, new VirtualFile[]{meteorLib}, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY);
                    libraryManager.commitChanges();
                });
            }
        });
    }

    private void updateModuleExcludeByFSEvent(VirtualFileEvent event, HashSet<String> oldToUpdateFolders, HashSet<String> newToUpdateFolders) {
        VirtualFile eventFile = event.getFile();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)eventFile, (Project)this.myProject);
        if (module == null) {
            return;
        }
        VirtualFile contentRoot = MeteorProjectComponent.getContentRoot(module, event.getParent());
        if (contentRoot == null) {
            return;
        }
        ModuleRootModificationUtil.updateExcludedFolders((Module)module, (VirtualFile)contentRoot, oldToUpdateFolders, newToUpdateFolders);
    }

    private static String getExcludedFolderName(VirtualFileEvent event) {
        return event.getFile().getUrl() + "/" + METEOR_LOCAL_FOLDER;
    }

    private static void excludeLocalMeteorFolders(Project project) {
        Collection<VirtualFile> meteorLocalFolders = MeteorFacade.getInstance().getMeteorFolders(project);
        for (VirtualFile meteorFolder : meteorLocalFolders) {
            Collection<String> oldExcludedFolders;
            VirtualFile root;
            VirtualFile contentRoot;
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)meteorFolder, (Project)project);
            if (module == null || (contentRoot = MeteorProjectComponent.getContentRoot(module, root = meteorFolder.getParent())) == null || (oldExcludedFolders = MeteorProjectComponent.getOldExcludedFolders(module, root)).size() == 1 && oldExcludedFolders.contains(meteorFolder.getUrl() + "/" + METEOR_LOCAL_FOLDER)) continue;
            ModuleRootModificationUtil.updateExcludedFolders((Module)module, (VirtualFile)contentRoot, oldExcludedFolders, (Collection)ContainerUtil.newHashSet((Object[])new String[]{meteorFolder.getUrl() + "/" + METEOR_LOCAL_FOLDER}));
        }
    }

    private boolean projectHasExcludedMeteorFolder() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (String url : ModuleRootManager.getInstance((Module)module).getExcludeRootUrls()) {
                String trimEnd = StringUtil.trimEnd((String)url, (String)"/");
                if (!trimEnd.endsWith("/.meteor") || JSLibraryUtil.isProbableLibraryPath((String)trimEnd)) continue;
                return true;
            }
        }
        return false;
    }

    private static VirtualFile getContentRoot(Module module, VirtualFile root) {
        return root == null ? null : ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getContentRootForFile(root);
    }

    private static Collection<String> getOldExcludedFolders(Module module, VirtualFile root) {
        return ContainerUtil.filter((Object[])ModuleRootManager.getInstance((Module)module).getExcludeRootUrls(), url -> url.startsWith(root.getUrl() + "/" + METEOR_RELATIVE_PATH_TO_LOCAL_FOLDER));
    }

    private static boolean isMeteorLibraryWasEnabled(Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(JS_METEOR_LIBRARY_WAS_ENABLED);
    }

    private static void setMeteorLibraryWasEnabled(Project project) {
        PropertiesComponent.getInstance((Project)project).setValue(JS_METEOR_LIBRARY_WAS_ENABLED, true);
    }
}

