/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.SwingHelper;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorUIUtil {
    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createTextField(@Nullable Project project) {
        TextFieldWithHistoryWithBrowseButton button = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)"Meteor executable", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), () -> MeteorUIUtil.getMeteorExecutableList());
        MeteorUIUtil.setValue(MeteorSettings.getInstance().getExecutablePath(), button);
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = button;
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/MeteorUIUtil", "createTextField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    public static void setValue(String value, TextFieldWithHistoryWithBrowseButton button) {
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)button.getChildComponent();
        if (!StringUtil.isEmpty((String)value)) {
            textFieldWithHistory.setText(value);
            textFieldWithHistory.addCurrentTextToHistory();
        }
    }

    public static List<String> getMeteorExecutableList() {
        return MeteorSettings.detectMeteorExecutablePaths();
    }

    public static TextFieldWithBrowseButton createPackagesField(Project project) {
        TextFieldWithBrowseButton fieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)fieldWithBrowseButton, (String)"Global Meteor root folder", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        return fieldWithBrowseButton;
    }
}

