/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.ide.action;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.jetbrains.plugins.meteor.ide.action.MeteorImportPackagesAsExternalLibAction;
import com.jetbrains.plugins.meteor.ide.action.MeteorPackagesUtil;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MeteorAutoImportProcessor {
    public static final Logger LOG = Logger.getInstance(MeteorAutoImportProcessor.class);
    private final Project myProject;
    private final MergingUpdateQueue myQueue;

    public static MeteorAutoImportProcessor get(Project project) {
        return (MeteorAutoImportProcessor)ServiceManager.getService((Project)project, MeteorAutoImportProcessor.class);
    }

    public MeteorAutoImportProcessor(Project project) {
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("Meteor update packages", 300, true, null, (Disposable)project, null, false);
    }

    public void update() {
        if (ApplicationManager.getApplication().isUnitTestMode() || !MeteorSettings.getInstance().isAutoImport()) {
            return;
        }
        this.myQueue.queue(new Update(this){

            public void run() {
                DumbService.getInstance((Project)MeteorAutoImportProcessor.this.myProject).runReadActionInSmartMode(() -> {
                    LOG.debug("Check meteor libraries");
                    MeteorAutoImportProcessor.this.importLibraryIfNeed();
                });
            }
        });
    }

    private void importLibraryIfNeed() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<MeteorImportPackagesAsExternalLibAction.CodeType> codes = MeteorPackagesUtil.getCodes(this.myProject);
        String pathToMeteorGlobal = MeteorPackagesUtil.getPathToGlobalMeteorRoot(this.myProject);
        if (StringUtil.isEmpty((String)pathToMeteorGlobal)) {
            return;
        }
        VirtualFile dotMeteorVirtualFile = MeteorPackagesUtil.getDotMeteorVirtualFile(this.myProject, null);
        if (dotMeteorVirtualFile == null) {
            LOG.debug("Cannot find .meteor folder");
            return;
        }
        if (codes.isEmpty()) {
            return;
        }
        VirtualFile versionsFile = MeteorPackagesUtil.getVersionsFile(this.myProject, dotMeteorVirtualFile);
        if (versionsFile == null) {
            return;
        }
        MultiMap<MeteorImportPackagesAsExternalLibAction.CodeType, VirtualFile> filesToImport = MeteorPackagesUtil.getFilesToImport(versionsFile, pathToMeteorGlobal, codes);
        if (this.checkPackagesUpToDate(filesToImport, codes)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> MeteorImportPackagesAsExternalLibAction.importLibrary(this.myProject, codes, filesToImport), this.myProject.getDisposed());
    }

    private boolean checkPackagesUpToDate(@NotNull MultiMap<MeteorImportPackagesAsExternalLibAction.CodeType, VirtualFile> toImportFiles, @NotNull Collection<MeteorImportPackagesAsExternalLibAction.CodeType> codes) {
        if (toImportFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImportFiles", "com/jetbrains/plugins/meteor/ide/action/MeteorAutoImportProcessor", "checkPackagesUpToDate"));
        }
        if (codes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codes", "com/jetbrains/plugins/meteor/ide/action/MeteorAutoImportProcessor", "checkPackagesUpToDate"));
        }
        HashSet oldFiles = ContainerUtil.newHashSet();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance((Project)this.myProject);
        for (MeteorImportPackagesAsExternalLibAction.CodeType code : codes) {
            String nameLib = MeteorImportPackagesAsExternalLibAction.getLibraryName(code);
            ScriptingLibraryModel model = libraryManager.getLibraryByName(nameLib);
            if (model == null) continue;
            oldFiles.addAll(model.getAllFiles());
        }
        return MeteorAutoImportProcessor.toList(toImportFiles).equals(oldFiles);
    }

    private static Collection<VirtualFile> toList(MultiMap<MeteorImportPackagesAsExternalLibAction.CodeType, VirtualFile> multiMap) {
        return ContainerUtil.newHashSet((Iterable)multiMap.values());
    }
}

