/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.ide.action;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.plugins.meteor.MeteorBundle;
import com.jetbrains.plugins.meteor.MeteorFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorHtmlFileTypeEditNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"MeteorHandlebarsEditorNotificationsProvider");
    private static final String METEOR_CHANGE_ASSOCIATION_DISMISSED = "js.meteor.notification.html.filetype.dismissed";
    private static final String HTML = "html";
    @NotNull
    private final Project myProject;

    public MeteorHtmlFileTypeEditNotificationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/ide/action/MeteorHtmlFileTypeEditNotificationProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorHtmlFileTypeEditNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        FileType html;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/meteor/ide/action/MeteorHtmlFileTypeEditNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/jetbrains/plugins/meteor/ide/action/MeteorHtmlFileTypeEditNotificationProvider", "createNotificationPanel"));
        }
        if (MeteorFacade.getInstance().isMeteorProject(this.myProject) && (html = FileTypeManager.getInstance().getFileTypeByExtension(HTML)) != HtmlFileType.INSTANCE && !PropertiesComponent.getInstance((Project)this.myProject).getBoolean(METEOR_CHANGE_ASSOCIATION_DISMISSED)) {
            return new IncorrectHtmlAssociationPanel();
        }
        return null;
    }

    private class IncorrectHtmlAssociationPanel
    extends EditorNotificationPanel {
        private IncorrectHtmlAssociationPanel() {
            super(EditorColors.GUTTER_BACKGROUND);
            this.setText(MeteorBundle.message("action.meteor.html.file.type.warning", new Object[0]));
            this.createActionLabel(MeteorBundle.message("action.meteor.html.file.type.change", new Object[0]), () -> ApplicationManager.getApplication().runWriteAction(() -> {
                FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                FileType oldType = fileTypeManager.getFileTypeByExtension(MeteorHtmlFileTypeEditNotificationProvider.HTML);
                fileTypeManager.removeAssociatedExtension(oldType, MeteorHtmlFileTypeEditNotificationProvider.HTML);
                fileTypeManager.associateExtension((FileType)HtmlFileType.INSTANCE, MeteorHtmlFileTypeEditNotificationProvider.HTML);
            }));
            this.createActionLabel(MeteorBundle.message("action.meteor.html.file.type.dismiss", new Object[0]), () -> {
                PropertiesComponent.getInstance((Project)MeteorHtmlFileTypeEditNotificationProvider.this.myProject).setValue(MeteorHtmlFileTypeEditNotificationProvider.METEOR_CHANGE_ASSOCIATION_DISMISSED, true);
                EditorNotifications.getInstance((Project)MeteorHtmlFileTypeEditNotificationProvider.this.myProject).updateAllNotifications();
            });
        }
    }
}

