/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.ide.action;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.jetbrains.plugins.meteor.ide.action.MeteorImportPackagesDialog;
import com.jetbrains.plugins.meteor.ide.action.MeteorPackagesUtil;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import icons.MeteorIcons;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorImportPackagesAsExternalLibAction
extends AnAction {
    public static final String METEOR_PACKAGES_LIB_NAME = "meteor-packages-auto-import";
    public static final String PACKAGES_FILE = "packages";
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"MeteorProject");

    public MeteorImportPackagesAsExternalLibAction() {
        super(MeteorIcons.Meteor2);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesAsExternalLibAction", "actionPerformed"));
        }
        assert (ApplicationManager.getApplication().isDispatchThread());
        Project project = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(event.getDataContext());
        PsiFile baseFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(event.getDataContext());
        if (project == null) {
            Module module = (Module)LangDataKeys.MODULE.getData(event.getDataContext());
            if (module != null) {
                project = module.getProject();
            }
            if (module == null && baseFile != null) {
                project = baseFile.getProject();
            }
        }
        if (project == null) {
            Messages.showErrorDialog((String)"Cannot find Project", (String)"Meteor Import Packages");
            return;
        }
        VirtualFile dotMeteorVirtualFile = MeteorPackagesUtil.getDotMeteorVirtualFile(project, baseFile);
        MeteorImportPackagesAsExternalLibAction.updateVersionList(dotMeteorVirtualFile, project);
    }

    private static void updateInfo(Project project, VirtualFile dotMeteorVirtualFile) throws IOException {
        VirtualFile versionsFile = MeteorPackagesUtil.getVersionsFile(project, dotMeteorVirtualFile);
        if (versionsFile == null) {
            Notification notification = NOTIFICATION_GROUP.createNotification("Cannot find file 'versions'. Check your Meteor has version 0.9.0 or higher", MessageType.WARNING);
            notification.notify(project);
            return;
        }
        MeteorImportPackagesDialog dialog = new MeteorImportPackagesDialog(project, MeteorPackagesUtil.getPathToGlobalMeteorRoot(project), MeteorPackagesUtil.getCodes(project));
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return;
        }
        Collection<CodeType> dialogCodeTypes = dialog.getCodeTypes();
        String pathToMeteorGlobal = dialog.getPath();
        MeteorPackagesUtil.setPathToGlobalMeteorRoot(project, pathToMeteorGlobal);
        MeteorPackagesUtil.setCodes(project, dialogCodeTypes);
        MultiMap<CodeType, VirtualFile> filesToImport = MeteorPackagesUtil.getFilesToImport(versionsFile, pathToMeteorGlobal, dialogCodeTypes);
        WriteAction.run(() -> MeteorImportPackagesAsExternalLibAction.importLibrary(project, dialogCodeTypes, filesToImport));
    }

    public static void importLibrary(@NotNull Project project, @NotNull Collection<CodeType> dialogCodeTypes, @NotNull MultiMap<CodeType, VirtualFile> filesToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesAsExternalLibAction", "importLibrary"));
        }
        if (dialogCodeTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialogCodeTypes", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesAsExternalLibAction", "importLibrary"));
        }
        if (filesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToImport", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesAsExternalLibAction", "importLibrary"));
        }
        for (Map.Entry entry : filesToImport.entrySet()) {
            MeteorImportPackagesAsExternalLibAction.createLibrary((Collection)entry.getValue(), project, (CodeType)((Object)entry.getKey()));
        }
        for (CodeType type : CodeType.values()) {
            if (dialogCodeTypes.contains((Object)type)) continue;
            MeteorImportPackagesAsExternalLibAction.createLibrary(ContainerUtil.emptyList(), project, type);
        }
    }

    private static void createLibrary(@NotNull Collection<VirtualFile> filesForLibrary, @NotNull Project finalProject, CodeType type) {
        if (filesForLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesForLibrary", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesAsExternalLibAction", "createLibrary"));
        }
        if (finalProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalProject", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesAsExternalLibAction", "createLibrary"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            String nameLib;
            if (finalProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalProject", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesAsExternalLibAction", "lambda$createLibrary$1"));
            }
            if (filesForLibrary == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesForLibrary", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesAsExternalLibAction", "lambda$createLibrary$1"));
            }
            JSLibraryManager libraryManager = JSLibraryManager.getInstance((Project)finalProject);
            ScriptingLibraryModel model = libraryManager.getLibraryByName(nameLib = MeteorImportPackagesAsExternalLibAction.getLibraryName(type));
            if (model != null) {
                libraryManager.removeLibrary(model);
            }
            if (filesForLibrary.size() > 0) {
                libraryManager.createLibrary(nameLib, filesForLibrary.toArray(new VirtualFile[filesForLibrary.size()]), VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PROJECT, true);
                libraryManager.associateWithProject(nameLib);
            }
            libraryManager.commitChanges();
        });
    }

    @NotNull
    public static String getLibraryName(CodeType type) {
        String string = "meteor-packages-auto-import-" + type.getNameEnd();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesAsExternalLibAction", "getLibraryName"));
        }
        return string;
    }

    private static void updateVersionList(@Nullable VirtualFile dotMeteorVirtualFile, Project project) {
        if (dotMeteorVirtualFile == null) {
            return;
        }
        VirtualFile folderWithDotMeteor = dotMeteorVirtualFile.getParent();
        String executablePath = MeteorSettings.getInstance().getExecutablePath();
        if (StringUtil.isEmpty((String)executablePath)) {
            Notification notification = NOTIFICATION_GROUP.createNotification("Cannot find Meteor executable. Please check Meteor settings", MessageType.WARNING);
            notification.notify(project);
            return;
        }
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setText("Updating Meteor packages info...");
                ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{executablePath, "list"}).withWorkDirectory(folderWithDotMeteor.getPath()));
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }, "Meteor Packages", true, project);
        if (!result) {
            return;
        }
        WriteAction.run(() -> dotMeteorVirtualFile.refresh(false, true));
        try {
            MeteorImportPackagesAsExternalLibAction.updateInfo(project, dotMeteorVirtualFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum CodeType {
        SERVER{

            @Override
            public String getFolder() {
                return "os";
            }

            @Override
            public String getNameEnd() {
                return "os";
            }
        }
        ,
        CLIENT{

            @Override
            public String getFolder() {
                return "web.browser";
            }

            @Override
            public String getNameEnd() {
                return "browser";
            }
        }
        ,
        CORDOVA{

            @Override
            public String getFolder() {
                return "web.cordova";
            }

            @Override
            public String getNameEnd() {
                return "cordova";
            }
        }
        ,
        NPM{

            @Override
            public String getFolder() {
                return "npm";
            }

            @Override
            public String getNameEnd() {
                return "npm";
            }
        };


        public abstract String getFolder();

        public abstract String getNameEnd();
    }
}

