/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.ide.action;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.plugins.meteor.MeteorBundle;
import com.jetbrains.plugins.meteor.MeteorUIUtil;
import com.jetbrains.plugins.meteor.ide.action.MeteorImportPackagesAsExternalLibAction;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorImportPackagesDialog
extends DialogWrapper {
    private final Project myProject;
    private String myDefaultPath;
    private final Collection<MeteorImportPackagesAsExternalLibAction.CodeType> myDefaultCodes;
    private JBCheckBox myImportServer;
    private JBCheckBox myImportClient;
    private JBCheckBox myImportCordova;
    private JBCheckBox myImportNpm;
    private TextFieldWithBrowseButton myPathField;

    public MeteorImportPackagesDialog(@NotNull Project project, @Nullable String defaultPath, @NotNull Collection<MeteorImportPackagesAsExternalLibAction.CodeType> defaultCodes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesDialog", "<init>"));
        }
        if (defaultCodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCodes", "com/jetbrains/plugins/meteor/ide/action/MeteorImportPackagesDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myDefaultPath = defaultPath;
        this.myDefaultCodes = defaultCodes;
        this.setTitle(MeteorBundle.message("action.meteor.import.packages.dialog.title", new Object[0]));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myPathField = MeteorUIUtil.createPackagesField(this.myProject);
        this.myImportClient = new JBCheckBox("Import client");
        this.myImportServer = new JBCheckBox("Import server");
        this.myImportCordova = new JBCheckBox("Import cordova");
        this.myImportNpm = new JBCheckBox("Import npm");
        for (MeteorImportPackagesAsExternalLibAction.CodeType code : this.myDefaultCodes) {
            JBCheckBox currentSelected = null;
            switch (code) {
                case CLIENT: {
                    currentSelected = this.myImportClient;
                    break;
                }
                case CORDOVA: {
                    currentSelected = this.myImportCordova;
                    break;
                }
                case SERVER: {
                    currentSelected = this.myImportServer;
                    break;
                }
                case NPM: {
                    currentSelected = this.myImportNpm;
                    break;
                }
            }
            if (currentSelected == null) continue;
            currentSelected.setSelected(true);
        }
        FormBuilder builder = FormBuilder.createFormBuilder().addLabeledComponent(MeteorBundle.message("action.meteor.import.packages.dialog.path.title", new Object[0]), (JComponent)this.myPathField).addComponent((JComponent)this.myImportClient).addComponent((JComponent)this.myImportNpm).addComponent((JComponent)this.myImportServer).addComponent((JComponent)this.myImportCordova);
        this.myPathField.setText(this.myDefaultPath);
        JPanel panel = builder.getPanel();
        panel.setPreferredSize((Dimension)JBUI.size((int)600, (int)40));
        return panel;
    }

    public String getPath() {
        return this.myPathField.getText();
    }

    public Collection<MeteorImportPackagesAsExternalLibAction.CodeType> getCodeTypes() {
        ArrayList result = ContainerUtil.newArrayList();
        if (this.myImportClient.isSelected()) {
            result.add(MeteorImportPackagesAsExternalLibAction.CodeType.CLIENT);
        }
        if (this.myImportServer.isSelected()) {
            result.add(MeteorImportPackagesAsExternalLibAction.CodeType.SERVER);
        }
        if (this.myImportCordova.isSelected()) {
            result.add(MeteorImportPackagesAsExternalLibAction.CodeType.CORDOVA);
        }
        if (this.myImportNpm.isSelected()) {
            result.add(MeteorImportPackagesAsExternalLibAction.CodeType.NPM);
        }
        return result;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmptyOrSpaces((String)this.myPathField.getText())) {
            return new ValidationInfo("Meteor packages folder is empty");
        }
        return null;
    }
}

