/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.ide.action;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.plugins.meteor.MeteorFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorPackagesEditNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"MeteorPackagesEditorNotificationsProvider");
    @NotNull
    private final Project myProject;

    public MeteorPackagesEditNotificationProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesEditNotificationProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesEditNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesEditNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesEditNotificationProvider", "createNotificationPanel"));
        }
        if (file.isInLocalFileSystem() && (file.getName().equals("versions") || file.getName().equals("packages")) && MeteorFacade.getInstance().isMeteorProject(this.myProject)) {
            return new ImportPackagesPanel();
        }
        return null;
    }

    private static class ImportPackagesPanel
    extends EditorNotificationPanel {
        private ImportPackagesPanel() {
            super(EditorColors.GUTTER_BACKGROUND);
            this.createActionLabel("Import packages as library", "Meteor.action.packages");
        }
    }
}

