/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.ide.action;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.meteor.MeteorFacade;
import com.jetbrains.plugins.meteor.ide.action.MeteorImportPackagesAsExternalLibAction;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class MeteorPackagesUtil {
    public static final Logger LOG = Logger.getInstance(MeteorPackagesUtil.class);
    public static final String PACKAGES_FOLDER = "packages";
    public static final String VERSIONS_FILE_NAME = "versions";
    public static final String SETTING_SCOPE_IMPORT = "meteor.settings.import.codes.2";
    public static final String SETTING_METEOR_GLOBAL = "meteor.settings.global.path";
    private static final Set<String> IGNORED_PACKAGES = ContainerUtil.immutableSet((Object[])new String[]{"meteor", "mongo", "minimongo", "templating"});
    private static final Set<String> EXCLUDED_FOLDERS = ContainerUtil.immutableSet((Object[])new String[]{"node_modules", "test", "example", "tests", "examples", "tmp"});
    private static final String[] EXTENSIONS = new String[]{".coffee", ".d.ts", ".ts", ".js", ".jsx", ".css"};

    public static MultiMap<MeteorImportPackagesAsExternalLibAction.CodeType, VirtualFile> getFilesToImport(@NotNull VirtualFile versionsFile, @NotNull String pathToMeteorGlobal, @NotNull Collection<MeteorImportPackagesAsExternalLibAction.CodeType> codes) {
        if (versionsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionsFile", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getFilesToImport"));
        }
        if (pathToMeteorGlobal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToMeteorGlobal", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getFilesToImport"));
        }
        if (codes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codes", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getFilesToImport"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MultiMap result = MultiMap.createSmart();
        try {
            String packagesPath = FileUtil.toCanonicalPath((String)pathToMeteorGlobal) + "/" + PACKAGES_FOLDER;
            VirtualFile packagesFolder = LocalFileFinder.findFile((String)packagesPath);
            if (packagesFolder == null) {
                return result;
            }
            if (!versionsFile.isValid()) {
                return result;
            }
            String s = VfsUtilCore.loadText((VirtualFile)versionsFile);
            Object[] strings = StringUtil.splitByLines((String)s, (boolean)true);
            List wrappers = ContainerUtil.mapNotNull((Object[])strings, rawVersionsLine -> {
                String[] split = rawVersionsLine.split("@");
                if (split.length != 2) {
                    return null;
                }
                return new PackageWrapper(split);
            });
            for (PackageWrapper wrapper : wrappers) {
                VirtualFile versionedPackage = MeteorPackagesUtil.getVersionPackage(packagesFolder, wrapper);
                for (MeteorImportPackagesAsExternalLibAction.CodeType type : codes) {
                    if (versionedPackage == null) {
                        result.putValues((Object)type, (Collection)ContainerUtil.emptyList());
                        continue;
                    }
                    ArrayList filesForLibrary = ContainerUtil.newArrayList();
                    filesForLibrary.addAll(MeteorPackagesUtil.getFileForLibrary(versionedPackage, type));
                    result.putValues((Object)type, (Collection)filesForLibrary);
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static VirtualFile getVersionPackage(VirtualFile packagesFolder, PackageWrapper wrapper) {
        if (IGNORED_PACKAGES.contains(wrapper.getName())) {
            return null;
        }
        VirtualFile rootForNamedPackage = packagesFolder.findChild(wrapper.getName());
        if (rootForNamedPackage == null) {
            rootForNamedPackage = packagesFolder.findChild(wrapper.getName());
        }
        if (rootForNamedPackage == null) {
            return null;
        }
        VirtualFile versionedPackage = rootForNamedPackage.findChild(wrapper.getVersion());
        if (versionedPackage == null) {
            versionedPackage = (VirtualFile)ArrayUtil.getFirstElement((Object[])rootForNamedPackage.getChildren());
        }
        return versionedPackage;
    }

    @Nullable
    static VirtualFile getDotMeteorVirtualFile(@NotNull Project project, @Nullable PsiFile baseFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getDotMeteorVirtualFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (baseFile == null) {
            Collection<VirtualFile> folders = MeteorFacade.getInstance().getMeteorFolders(project);
            return folders.size() == 1 ? (VirtualFile)ContainerUtil.getFirstItem(folders) : null;
        }
        VirtualFile parent = baseFile.getVirtualFile().getParent();
        if (parent == null) {
            return null;
        }
        if (!".meteor".equals(parent.getName())) {
            return null;
        }
        return parent;
    }

    @Nullable
    static VirtualFile getVersionsFile(@NotNull Project project, @Nullable VirtualFile dotMeteorVirtualFile) {
        Object versions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getVersionsFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (dotMeteorVirtualFile != null && (versions = dotMeteorVirtualFile.findChild(VERSIONS_FILE_NAME)) != null) {
            return versions;
        }
        versions = FilenameIndex.getVirtualFilesByName((Project)project, (String)VERSIONS_FILE_NAME, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        if (versions.size() != 1) {
            return null;
        }
        return (VirtualFile)ContainerUtil.getFirstItem((Collection)versions);
    }

    @NotNull
    private static List<VirtualFile> getFileForLibrary(@NotNull VirtualFile versionedPackage, MeteorImportPackagesAsExternalLibAction.CodeType type) {
        if (versionedPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionedPackage", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getFileForLibrary"));
        }
        List<VirtualFile> list = MeteorPackagesUtil.getFileFromActualPackageFolder(versionedPackage, type);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getFileForLibrary"));
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> getFileFromActualPackageFolder(@NotNull VirtualFile folder, MeteorImportPackagesAsExternalLibAction.CodeType type) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getFileFromActualPackageFolder"));
        }
        ArrayList files = ContainerUtil.newArrayList();
        VirtualFile os = folder.findChild(type.getFolder());
        if (type == MeteorImportPackagesAsExternalLibAction.CodeType.NPM) {
            VirtualFile modules;
            if (os != null && (modules = os.findChild("node_modules")) != null) {
                MeteorPackagesUtil.addNpmPackages(files, modules);
            }
            ArrayList arrayList = files;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getFileFromActualPackageFolder"));
            }
            return arrayList;
        }
        if (os != null) {
            MeteorPackagesUtil.addFiles(files, os);
        }
        ArrayList arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getFileFromActualPackageFolder"));
        }
        return arrayList;
    }

    private static void addNpmPackages(List<VirtualFile> files, @NotNull VirtualFile nodeModulesFolder) {
        if (nodeModulesFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesFolder", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "addNpmPackages"));
        }
        for (VirtualFile file : nodeModulesFolder.getChildren()) {
            if (!file.isDirectory()) continue;
            for (VirtualFile virtualFile : file.getChildren()) {
                if (EXCLUDED_FOLDERS.contains(virtualFile.getName())) continue;
                MeteorPackagesUtil.addFiles(files, virtualFile);
            }
        }
    }

    private static void addFiles(List<VirtualFile> files, VirtualFile os) {
        VfsUtilCore.processFilesRecursively((VirtualFile)os, file -> {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            for (String extension : EXTENSIONS) {
                if (!name.endsWith(extension)) continue;
                files.add((VirtualFile)file);
                break;
            }
            return true;
        });
    }

    public static String getPathToGlobalMeteorRoot(Project project) {
        String settings = PropertiesComponent.getInstance((Project)project).getValue(SETTING_METEOR_GLOBAL);
        return StringUtil.isEmpty((String)settings) ? MeteorPackagesUtil.getDefaultPathToGlobalMeteorRoot() : settings;
    }

    public static void setPathToGlobalMeteorRoot(@NotNull Project project, @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "setPathToGlobalMeteorRoot"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "setPathToGlobalMeteorRoot"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(SETTING_METEOR_GLOBAL, value, MeteorPackagesUtil.getDefaultPathToGlobalMeteorRoot());
    }

    @NotNull
    public static Collection<MeteorImportPackagesAsExternalLibAction.CodeType> getCodes(Project project) {
        String settings = PropertiesComponent.getInstance((Project)project).getValue(SETTING_SCOPE_IMPORT);
        Collection<MeteorImportPackagesAsExternalLibAction.CodeType> collection = StringUtil.isEmpty((String)settings) ? MeteorPackagesUtil.getDefaultCodes() : MeteorPackagesUtil.parse(settings);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getCodes"));
        }
        return collection;
    }

    @NotNull
    private static EnumSet<MeteorImportPackagesAsExternalLibAction.CodeType> getDefaultCodes() {
        EnumSet<MeteorImportPackagesAsExternalLibAction.CodeType> enumSet = EnumSet.of(MeteorImportPackagesAsExternalLibAction.CodeType.CLIENT, MeteorImportPackagesAsExternalLibAction.CodeType.NPM);
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getDefaultCodes"));
        }
        return enumSet;
    }

    public static void setCodes(@NotNull Project project, Collection<MeteorImportPackagesAsExternalLibAction.CodeType> codes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "setCodes"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(SETTING_SCOPE_IMPORT, MeteorPackagesUtil.codesToString(codes), MeteorPackagesUtil.codesToString(MeteorPackagesUtil.getDefaultCodes()));
    }

    private static Collection<MeteorImportPackagesAsExternalLibAction.CodeType> parse(String value) {
        String[] split;
        EnumSet<MeteorImportPackagesAsExternalLibAction.CodeType> types = EnumSet.noneOf(MeteorImportPackagesAsExternalLibAction.CodeType.class);
        for (String s : split = value.split(";")) {
            types.add(MeteorImportPackagesAsExternalLibAction.CodeType.valueOf(s));
        }
        return types;
    }

    private static String codesToString(Collection<MeteorImportPackagesAsExternalLibAction.CodeType> codes) {
        return StringUtil.join(codes, type -> type.name(), (String)";");
    }

    @NotNull
    public static String getDefaultPathToGlobalMeteorRoot() {
        if (!SystemInfo.isWindows) {
            String string = SystemProperties.getUserHome() + "/" + ".meteor";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getDefaultPathToGlobalMeteorRoot"));
            }
            return string;
        }
        String meteorExecutable = MeteorSettings.getInstance().getExecutablePath();
        if (StringUtil.isEmpty((String)meteorExecutable)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getDefaultPathToGlobalMeteorRoot"));
            }
            return "";
        }
        VirtualFile file = LocalFileFinder.findFile((String)meteorExecutable);
        if (file == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getDefaultPathToGlobalMeteorRoot"));
            }
            return "";
        }
        String string = file.getParent().getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil", "getDefaultPathToGlobalMeteorRoot"));
        }
        return string;
    }

    private static class PackageWrapper {
        private String myVersion;
        private String myName;

        private PackageWrapper(@NotNull String[] strings) {
            if (strings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/jetbrains/plugins/meteor/ide/action/MeteorPackagesUtil$PackageWrapper", "<init>"));
            }
            assert (strings.length == 2);
            this.myName = strings[0].replace(':', '_');
            this.myVersion = strings[1];
        }

        private String getVersion() {
            return this.myVersion;
        }

        private String getName() {
            return this.myName;
        }
    }
}

