/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.projectGenerator;

import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.jetbrains.plugins.meteor.MeteorBundle;
import com.jetbrains.plugins.meteor.MeteorUIUtil;
import com.jetbrains.plugins.meteor.projectGenerator.MeteorProjectTemplateGenerator;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorProjectPeer
implements WebProjectGenerator.GeneratorPeer<MeteorProjectTemplateGenerator.MeteorProjectSettings> {
    public static final String EMPTY_PROJECT_TYPE = "default";
    public static final Map<String, RepoInfo> PROJECT_TYPES = ContainerUtil.newLinkedHashMap();
    static final String OWNER_NAME = "meteor";
    private final List<WebProjectGenerator.SettingsStateListener> myStateListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private TextFieldWithHistoryWithBrowseButton myExecutablePathField;
    private JComboBox myProjectType = new ComboBox();
    private JTextField myName = new JBTextField();

    MeteorProjectPeer() {
        this.myName.setText("hello");
        this.myProjectType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Container parent = MeteorProjectPeer.this.myName.getParent();
                boolean enabled = MeteorProjectPeer.EMPTY_PROJECT_TYPE.equals(MeteorProjectPeer.this.myProjectType.getSelectedItem());
                if (parent instanceof LabeledComponent) {
                    parent.setVisible(enabled);
                } else {
                    MeteorProjectPeer.this.myName.setEnabled(enabled);
                }
            }
        });
    }

    private void createAndInit() {
        this.myExecutablePathField = MeteorUIUtil.createTextField(null);
        SwingHelper.updateItems((JComboBox)this.myProjectType, this.getProjectTypes(), null);
    }

    @NotNull
    public JComponent getComponent() {
        this.createAndInit();
        JPanel jPanel = FormBuilder.createFormBuilder().addLabeledComponent(MeteorBundle.message("settings.meteor.configurable.executable.generator", new Object[0]), (JComponent)this.myExecutablePathField).addLabeledComponent(MeteorBundle.message("settings.meteor.project.generator.type", new Object[0]), (JComponent)this.myProjectType).addLabeledComponent(MeteorBundle.message("settings.meteor.project.generator.app.name", new Object[0]), (JComponent)this.myName).getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectPeer", "getComponent"));
        }
        return jPanel;
    }

    protected List<String> getProjectTypes() {
        return ContainerUtil.newArrayList(PROJECT_TYPES.keySet());
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectPeer", "buildUI"));
        }
        this.createAndInit();
        settingsStep.addSettingsField(MeteorBundle.message("settings.meteor.configurable.executable.generator", new Object[0]), (JComponent)SwingHelper.wrapWithHorizontalStretch((JComponent)this.myExecutablePathField));
        settingsStep.addSettingsField(MeteorBundle.message("settings.meteor.project.generator.type", new Object[0]), (JComponent)this.myProjectType);
        settingsStep.addSettingsField(MeteorBundle.message("settings.meteor.project.generator.app.name", new Object[0]), (JComponent)this.myName);
    }

    @NotNull
    public MeteorProjectTemplateGenerator.MeteorProjectSettings getSettings() {
        MeteorProjectTemplateGenerator.MeteorProjectSettings settings = new MeteorProjectTemplateGenerator.MeteorProjectSettings();
        settings.setMeteorExecutablePath(this.myExecutablePathField.getText());
        settings.setType((String)this.myProjectType.getSelectedItem());
        settings.setName(this.myName.getText());
        MeteorProjectTemplateGenerator.MeteorProjectSettings meteorProjectSettings = settings;
        if (meteorProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectPeer", "getSettings"));
        }
        return meteorProjectSettings;
    }

    @Nullable
    public ValidationInfo validate() {
        boolean error;
        String path = this.myExecutablePathField.getText();
        try {
            File file = new File(path);
            error = !file.exists() || !StringUtil.toLowerCase((String)file.getName()).contains(OWNER_NAME) || !file.isFile() || !file.canExecute();
        }
        catch (Exception e) {
            error = true;
        }
        return error ? new ValidationInfo("Incorrect Meteor executable") : null;
    }

    public boolean isBackgroundJobRunning() {
        return false;
    }

    public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectPeer", "addSettingsStateListener"));
        }
        this.myStateListeners.add(listener);
    }

    static {
        PROJECT_TYPES.put(EMPTY_PROJECT_TYPE, null);
        PROJECT_TYPES.put("clock", null);
        PROJECT_TYPES.put("leaderboard", null);
        PROJECT_TYPES.put("localmarket", null);
        PROJECT_TYPES.put("simple-todos", null);
        PROJECT_TYPES.put("simple-todos-react", null);
        PROJECT_TYPES.put("simple-todos-angular", null);
        PROJECT_TYPES.put("todos", null);
        PROJECT_TYPES.put("todos-react", new RepoInfo("todos", "react"));
        PROJECT_TYPES.put("angular2-boilerplate", new RepoInfo("bsliran", "angular2-meteor-base", "master"));
    }

    public static class RepoInfo {
        public final String myRepo;
        public final String myBranch;
        public final String myUser;

        public RepoInfo(@NotNull String user, @NotNull String repo, @NotNull String branch) {
            if (user == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectPeer$RepoInfo", "<init>"));
            }
            if (repo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectPeer$RepoInfo", "<init>"));
            }
            if (branch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectPeer$RepoInfo", "<init>"));
            }
            this.myUser = user;
            this.myRepo = repo;
            this.myBranch = branch;
        }

        public RepoInfo(@NotNull String repo, @NotNull String branch) {
            if (repo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectPeer$RepoInfo", "<init>"));
            }
            if (branch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectPeer$RepoInfo", "<init>"));
            }
            this(MeteorProjectPeer.OWNER_NAME, repo, branch);
        }
    }
}

