/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.projectGenerator;

import com.dmarcotte.handlebars.config.HbConfig;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.meteor.MeteorBundle;
import com.jetbrains.plugins.meteor.MeteorFacade;
import com.jetbrains.plugins.meteor.MeteorProjectComponent;
import com.jetbrains.plugins.meteor.projectGenerator.MeteorProjectPeer;
import com.jetbrains.plugins.meteor.runner.MeteorConfigurationType;
import com.jetbrains.plugins.meteor.runner.MeteorRunConfiguration;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import icons.MeteorIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MeteorProjectTemplateGenerator
extends WebProjectTemplate<MeteorProjectSettings> {
    private static final Logger LOG = Logger.getInstance(MeteorProjectTemplateGenerator.class);
    public static final String DEFAULT_TEMPLATE_NAME = "hello";
    private static final String EXAMPLE_PARAM = "--example";

    @Nls
    @NotNull
    public String getName() {
        String string = MeteorBundle.message("settings.meteor.project.generator.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "getName"));
        }
        return string;
    }

    public String getDescription() {
        return MeteorBundle.message("settings.meteor.project.generator.descr", new Object[0]);
    }

    private static void setProjectLanguageLevel(@NotNull Project project, MeteorProjectSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "setProjectLanguageLevel"));
        }
        String type = settings.myType;
        JSLanguageLevel level = JSLanguageLevel.ES6;
        if (type.contains("react")) {
            level = JSLanguageLevel.JSX;
        }
        JSRootConfiguration.getInstance((Project)project).storeLanguageLevelAndUpdateCaches(level);
    }

    private static void setHandlebarsSettings(@NotNull Project project, MeteorProjectSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "setHandlebarsSettings"));
        }
        if (settings.myType.contains("angular")) {
            HbConfig.setShouldOpenHtmlAsHandlebars((boolean)false, (Project)project);
        }
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull MeteorProjectSettings settings, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "generateProject"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "generateProject"));
        }
        Ref noErrorOnProjectCreating = Ref.create((Object)false);
        MeteorProjectTemplateGenerator.setProjectLanguageLevel(project, settings);
        MeteorProjectTemplateGenerator.setHandlebarsSettings(project, settings);
        MeteorFacade.getInstance().setIsMeteorProject(project);
        if ("default".equals(settings.myType)) {
            this.createDefaultProject(project, baseDir, settings, (Ref<Boolean>)noErrorOnProjectCreating);
        } else {
            this.createGithubProject(project, baseDir, settings, (Ref<Boolean>)noErrorOnProjectCreating);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "lambda$generateProject$0"));
            }
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "lambda$generateProject$0"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "lambda$generateProject$0"));
            }
            if (((Boolean)noErrorOnProjectCreating.get()).booleanValue()) {
                MeteorProjectComponent.initMeteorProject(project, false);
                MeteorProjectTemplateGenerator.createRunConfiguration(project, baseDir, settings);
                if (!StringUtil.equals((CharSequence)settings.myMeteorExecutablePath, (CharSequence)MeteorSettings.getInstance().getExecutablePath())) {
                    MeteorSettings.getInstance().setExecutablePath(settings.myMeteorExecutablePath);
                }
            }
            baseDir.refresh(true, true);
        });
    }

    public void createDefaultProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull MeteorProjectSettings settings, Ref<Boolean> noErrorOnProjectCreating) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createDefaultProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createDefaultProject"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createDefaultProject"));
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "lambda$createDefaultProject$1"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "lambda$createDefaultProject$1"));
            }
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "lambda$createDefaultProject$1"));
            }
            try {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setText("Creating Meteor project...");
                this.executeCommandLineForDefaultProject(indicator, settings, project, baseDir, noErrorOnProjectCreating);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                MeteorProjectTemplateGenerator.showErrorMessage(e.getMessage());
            }
        }, "Meteor Project Generator", false, project);
    }

    public void createGithubProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull MeteorProjectSettings settings, Ref<Boolean> noErrorOnProjectCreating) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createGithubProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createGithubProject"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createGithubProject"));
        }
        File zipArchiveFile = null;
        try {
            String ghUserName = settings.getOwner();
            String ghRepo = settings.getGithubrepositoryName();
            String ghBranch = settings.getGithubRepositoryBranch();
            zipArchiveFile = GithubDownloadUtil.findCacheFile((String)ghUserName, (String)ghRepo, (String)("meteor-" + ghRepo + ".zip"));
            GithubDownloadUtil.downloadContentToFileWithProgressSynchronously((Project)project, (String)GithubProjectGeneratorPeer.getGithubZipballUrl((String)ghUserName, (String)ghRepo, (String)ghBranch), (String)this.getName(), (File)zipArchiveFile, (String)ghUserName, (String)ghRepo, (boolean)false);
            ZipUtil.unzipWithProgressSynchronously((Project)project, (String)this.getName(), (File)zipArchiveFile, (File)VfsUtilCore.virtualToIoFile((VirtualFile)baseDir), null, (boolean)true);
            noErrorOnProjectCreating.set((Object)true);
        }
        catch (Exception e) {
            if (zipArchiveFile != null) {
                FileUtil.delete(zipArchiveFile);
            }
            LOG.warn((Throwable)e);
            MeteorProjectTemplateGenerator.showErrorMessage(e.getMessage());
        }
    }

    public void executeCommandLineForDefaultProject(ProgressIndicator indicator, @NotNull MeteorProjectSettings settings, @NotNull Project project, @NotNull VirtualFile baseDir, Ref<Boolean> noErrorOnProjectCreating) throws IOException, ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "executeCommandLineForDefaultProject"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "executeCommandLineForDefaultProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "executeCommandLineForDefaultProject"));
        }
        File tempProject = this.createTemp();
        ArrayList params = ContainerUtil.newArrayList((Object[])new String[]{settings.getCommand()});
        params.addAll(settings.params());
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine((List)params).withWorkDirectory(tempProject));
        if (output.getExitCode() != 0) {
            MeteorProjectTemplateGenerator.showErrorMessage(output.getStderr());
            this.deleteTemp(tempProject);
            return;
        }
        indicator.setText("Prepare project directory...");
        Object[] array = new File(tempProject.toURI()).listFiles();
        if (array != null && array.length != 0) {
            File from = (File)ContainerUtil.getFirstItem((List)ContainerUtil.newArrayList((Object[])array));
            assert (from != null);
            FileUtil.copyDir((File)from, (File)new File(baseDir.getPath()));
        }
        noErrorOnProjectCreating.set((Object)true);
        this.deleteTemp(tempProject);
    }

    private static void createRunConfiguration(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull MeteorProjectSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createRunConfiguration"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createRunConfiguration"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createRunConfiguration"));
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        MeteorConfigurationType configurationType = (MeteorConfigurationType)ConfigurationTypeUtil.findConfigurationType(MeteorConfigurationType.class);
        RunnerAndConfigurationSettings configuration = runManager.createRunConfiguration("Run Meteor", configurationType.getConfigurationFactories()[0]);
        MeteorRunConfiguration runConfiguration = (MeteorRunConfiguration)configuration.getConfiguration();
        runConfiguration.setWorkingDirectory(baseDir.getCanonicalPath());
        runManager.addConfiguration(configuration, false);
        runManager.setSelectedConfiguration(configuration);
    }

    protected File createTemp() throws IOException {
        return FileUtil.createTempDirectory((String)"intellij-meteor-generator", null, (boolean)false);
    }

    protected void deleteTemp(File tempProject) {
        if (!FileUtil.delete((File)tempProject)) {
            LOG.warn("Cannot delete " + tempProject);
        } else {
            LOG.info("Successfully deleted " + tempProject);
        }
    }

    @NotNull
    public MeteorProjectPeer createPeer() {
        MeteorProjectPeer meteorProjectPeer = new MeteorProjectPeer();
        if (meteorProjectPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "createPeer"));
        }
        return meteorProjectPeer;
    }

    public Icon getIcon() {
        return MeteorIcons.Meteor2;
    }

    private static void showErrorMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/meteor/projectGenerator/MeteorProjectTemplateGenerator", "showErrorMessage"));
        }
        String fullMessage = "Error creating Meteor App. " + message;
        String title = "Meteor project";
        Notifications.Bus.notify((Notification)new Notification("Meteor JS Generator", title, fullMessage, NotificationType.ERROR));
    }

    public static final class MeteorProjectSettings {
        private String myType;
        private String myMeteorExecutablePath;
        private String myName;

        public void setType(String type) {
            this.myType = type;
        }

        public void setMeteorExecutablePath(String meteorExecutablePath) {
            this.myMeteorExecutablePath = meteorExecutablePath;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public String getCommand() {
            return this.myMeteorExecutablePath;
        }

        public List<String> params() {
            ArrayList create = ContainerUtil.newArrayList((Object[])new String[]{"create"});
            if (!"default".equals(this.myType)) {
                return ContainerUtil.emptyList();
            }
            create.add(StringUtil.isEmpty((String)this.myName) ? MeteorProjectTemplateGenerator.DEFAULT_TEMPLATE_NAME : this.myName);
            return create;
        }

        public String getGithubRepositoryBranch() {
            MeteorProjectPeer.RepoInfo info = MeteorProjectPeer.PROJECT_TYPES.get(this.myType);
            return info != null ? info.myBranch : "master";
        }

        public String getGithubrepositoryName() {
            MeteorProjectPeer.RepoInfo info = MeteorProjectPeer.PROJECT_TYPES.get(this.myType);
            return info != null ? info.myRepo : this.myType;
        }

        public String getOwner() {
            MeteorProjectPeer.RepoInfo info = MeteorProjectPeer.PROJECT_TYPES.get(this.myType);
            return info != null ? info.myUser : "meteor";
        }
    }
}

