/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.plugins.meteor.runner.MeteorDebugProcess;
import com.jetbrains.plugins.meteor.runner.MeteorDebuggableProcessHandler;
import com.jetbrains.plugins.meteor.runner.MeteorErrorFilter;
import com.jetbrains.plugins.meteor.runner.MeteorMainProcessHandler;
import com.jetbrains.plugins.meteor.runner.MeteorRunConfiguration;
import com.jetbrains.plugins.meteor.runner.MeteorRunProfileState;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;

public class MeteorDebugProcessRunner
extends GenericProgramRunner {
    @NotNull
    public String getRunnerId() {
        if ("MeteorDebugRunner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorDebugProcessRunner", "getRunnerId"));
        }
        return "MeteorDebugRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/plugins/meteor/runner/MeteorDebugProcessRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/plugins/meteor/runner/MeteorDebugProcessRunner", "canRun"));
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof MeteorRunConfiguration;
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        InetSocketAddress socketAddress;
        MeteorMainProcessHandler possibleMainProcessHandler;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/plugins/meteor/runner/MeteorDebugProcessRunner", "doExecute"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/plugins/meteor/runner/MeteorDebugProcessRunner", "doExecute"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        MeteorRunProfileState profileState = (MeteorRunProfileState)state;
        MeteorRunConfiguration configuration = (MeteorRunConfiguration)environment.getRunProfile();
        if (MeteorDebugProcessRunner.isOnceEnabled()) {
            InetSocketAddress socketAddress2 = configuration.computeDebugAddress(state);
            MeteorMainProcessHandler mainProcessHandler = profileState.getProcessHandler(socketAddress2.getPort());
            XDebugSession session = MeteorDebugProcessRunner.createSession(environment, socketAddress2, new DefaultExecutionResult(null, (ProcessHandler)mainProcessHandler));
            return session.getRunContentDescriptor();
        }
        MeteorMainProcessHandler mainProcessHandler = null;
        RunContentDescriptor oldContentDescriptor = environment.getContentToReuse();
        if (oldContentDescriptor != null && oldContentDescriptor.getProcessHandler() != null && oldContentDescriptor.getProcessHandler() instanceof MeteorDebuggableProcessHandler && MeteorDebugProcessRunner.isAliveProcessHandler((ProcessHandler)(possibleMainProcessHandler = ((MeteorDebuggableProcessHandler)oldContentDescriptor.getProcessHandler()).getMainHandler()))) {
            mainProcessHandler = possibleMainProcessHandler;
        }
        InetSocketAddress inetSocketAddress = socketAddress = mainProcessHandler == null ? configuration.computeDebugAddress(state) : mainProcessHandler.getSocketAddress();
        if (mainProcessHandler == null) {
            mainProcessHandler = profileState.getProcessHandler(socketAddress.getPort());
            mainProcessHandler.setSocketAddress(socketAddress);
        }
        MeteorDebuggableProcessHandler debuggableProcessHandler = new MeteorDebuggableProcessHandler(mainProcessHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult(null, (ProcessHandler)debuggableProcessHandler);
        XDebugSession session = MeteorDebugProcessRunner.createSession(environment, socketAddress, executionResult);
        ConsoleView view = session.getConsoleView();
        String workingDirectory = configuration.getEffectiveWorkingDirectory();
        view.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(environment.getProject(), workingDirectory));
        view.addMessageFilter((Filter)new UrlFilter());
        view.addMessageFilter((Filter)new MeteorErrorFilter(environment.getProject(), workingDirectory));
        RunContentDescriptor descriptor = session.getRunContentDescriptor();
        JavaScriptDebugProcess process = (JavaScriptDebugProcess)session.getDebugProcess();
        debuggableProcessHandler.setVmConnection((RemoteVmConnection)process.getConnection());
        debuggableProcessHandler.setRunContentDescriptor(descriptor);
        debuggableProcessHandler.createTextMessagesListener();
        if (!mainProcessHandler.isStartNotified()) {
            mainProcessHandler.startNotify();
        }
        return descriptor;
    }

    private static boolean isOnceEnabled() {
        return MeteorSettings.getInstance().isStartOnce();
    }

    @NotNull
    private static XDebugSession createSession(ExecutionEnvironment environment, final InetSocketAddress socketAddress, final DefaultExecutionResult executionResult) throws ExecutionException {
        final MeteorRunConfiguration configuration = (MeteorRunConfiguration)environment.getRunProfile();
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/plugins/meteor/runner/MeteorDebugProcessRunner$1", "start"));
                }
                RemoteVmConnection connection = NodeDebugProgramRunnerKt.createRemoteConnection();
                MeteorDebugProcess process = new MeteorDebugProcess(session, connection, configuration.createFileFinder(session.getProject()), true, (ExecutionResult)executionResult);
                RemoteVmConnectionKt.open((RemoteVmConnection)connection, (InetSocketAddress)socketAddress, (ProcessHandler)executionResult.getProcessHandler());
                MeteorDebugProcess meteorDebugProcess = process;
                if (meteorDebugProcess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorDebugProcessRunner$1", "start"));
                }
                return meteorDebugProcess;
            }
        });
        if (xDebugSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorDebugProcessRunner", "createSession"));
        }
        return xDebugSession;
    }

    static ProcessAdapter getListenerForMainProcess(final MeteorDebuggableProcessHandler debugProcessHandler) {
        return new ProcessAdapter(){

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                if (!debugProcessHandler.isCalledDestroyParent()) {
                    debugProcessHandler.destroyProcess();
                }
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                debugProcessHandler.notifyTextAvailable(event.getText(), outputType);
            }
        };
    }

    static boolean isAliveProcessHandler(ProcessHandler processHandler) {
        return !processHandler.isProcessTerminating() && !processHandler.isProcessTerminated();
    }
}

