/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.intellij.execution.KillableProcess;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.jetbrains.plugins.meteor.runner.MeteorDebugProcessRunner;
import com.jetbrains.plugins.meteor.runner.MeteorMainProcessHandler;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.RemoteVmConnection;

public class MeteorDebuggableProcessHandler
extends DefaultDebugProcessHandler
implements KillableProcess {
    @NotNull
    private final MeteorMainProcessHandler myMainProcessHandler;
    @Nullable
    private volatile ProcessAdapter myListener;
    private volatile RunContentDescriptor myRunContentDescriptor;
    private volatile RemoteVmConnection myVmConnection;
    private boolean myCalledDestroyParent;

    public boolean isCalledDestroyParent() {
        return this.myCalledDestroyParent;
    }

    @NotNull
    MeteorMainProcessHandler getMainHandler() {
        MeteorMainProcessHandler meteorMainProcessHandler = this.myMainProcessHandler;
        if (meteorMainProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorDebuggableProcessHandler", "getMainHandler"));
        }
        return meteorMainProcessHandler;
    }

    MeteorDebuggableProcessHandler(@NotNull MeteorMainProcessHandler mainProcessHandler) {
        if (mainProcessHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainProcessHandler", "com/jetbrains/plugins/meteor/runner/MeteorDebuggableProcessHandler", "<init>"));
        }
        this.myMainProcessHandler = mainProcessHandler;
    }

    public OutputStream getProcessInput() {
        return this.myMainProcessHandler.getProcessInput();
    }

    public boolean detachIsDefault() {
        return false;
    }

    public void destroyProcess() {
        boolean isExternalDisconnect;
        boolean bl = isExternalDisconnect = this.isParentAlive() && this.myVmConnection != null && this.myVmConnection.getState().getStatus() == ConnectionStatus.DISCONNECTED;
        if (!isExternalDisconnect) {
            this.myCalledDestroyParent = true;
            this.myMainProcessHandler.destroyProcess();
        }
        this.myMainProcessHandler.removeProcessListener((ProcessListener)this.myListener);
        this.myVmConnection = null;
        super.destroyProcess();
        if (isExternalDisconnect) {
            AppUIUtil.invokeOnEdt(() -> {
                if (this.isParentAlive()) {
                    ExecutionUtil.restart((RunContentDescriptor)this.myRunContentDescriptor);
                }
            });
        }
    }

    public boolean isProcessTerminated() {
        return !this.myMainProcessHandler.isProcessTerminating() && super.isProcessTerminated();
    }

    public void setRunContentDescriptor(RunContentDescriptor runContentDescriptor) {
        this.myRunContentDescriptor = runContentDescriptor;
    }

    public void setVmConnection(RemoteVmConnection vmConnection) {
        this.myVmConnection = vmConnection;
    }

    private boolean isParentAlive() {
        return MeteorDebugProcessRunner.isAliveProcessHandler((ProcessHandler)this.myMainProcessHandler);
    }

    public boolean canKillProcess() {
        return this.myMainProcessHandler.canKillProcess();
    }

    public void killProcess() {
        this.myMainProcessHandler.killProcess();
    }

    public void createTextMessagesListener() {
        this.myListener = MeteorDebugProcessRunner.getListenerForMainProcess(this);
        List<Pair<String, Key>> messages = this.myMainProcessHandler.getLastMessage();
        for (Pair<String, Key> message : messages) {
            this.notifyTextAvailable((String)message.first, (Key)message.second);
        }
        this.myMainProcessHandler.addProcessListener((ProcessListener)this.myListener);
    }
}

