/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.intellij.execution.filters.Filter;
import com.intellij.javascript.nodejs.PatternBasedNodeJsFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class MeteorErrorFilter
extends PatternBasedNodeJsFilter {
    public static final String START_PATTERN = "(STDERR)";
    public static final String APP_PREFIX = "app/";
    private final String myDirectory;
    public static final Pattern[] MY_PATTERNS = (Pattern[])ArrayUtil.mergeArrays((Object[])ALL_PATTERNS, (Object[])new Pattern[]{Pattern.compile("^\\s*(\\S.*):(\\d+):(\\d+)(?:.*)?$")});

    public MeteorErrorFilter(@NotNull Project project, @Nullable String workDirectory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/runner/MeteorErrorFilter", "<init>"));
        }
        super(project);
        this.myDirectory = workDirectory == null ? null : StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)workDirectory), (char)'/');
    }

    public Filter.Result applyFilter(String outLine, int entireLength) {
        int index = outLine.indexOf(START_PATTERN);
        if (index >= 0) {
            outLine = outLine.substring(index + START_PATTERN.length());
        }
        return super.applyFilter(outLine, entireLength);
    }

    protected Pattern[] getPatterns() {
        return MY_PATTERNS;
    }

    protected VirtualFile findVirtualFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/plugins/meteor/runner/MeteorErrorFilter", "findVirtualFile"));
        }
        fileName = FileUtil.toSystemIndependentName((String)fileName);
        if (this.myDirectory != null && !fileName.startsWith("/")) {
            if (fileName.startsWith(APP_PREFIX)) {
                fileName = fileName.substring(APP_PREFIX.length());
            }
            return LocalFileFinder.findFile((String)(this.myDirectory + "/" + fileName));
        }
        return super.findVirtualFile(fileName);
    }
}

