/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MeteorMainProcessHandler
extends KillableColoredProcessHandler {
    private static final int QUEUE_LIMIT = 300;
    private volatile InetSocketAddress mySocketAddress;
    private volatile Deque<Pair<String, Key>> myLastMessage;
    private final Object myLock;

    public MeteorMainProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/plugins/meteor/runner/MeteorMainProcessHandler", "<init>"));
        }
        super(commandLine, true);
        this.myLastMessage = new ArrayDeque<Pair<String, Key>>(300);
        this.myLock = new Object();
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                MeteorMainProcessHandler.this.addMessage(event, outputType);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<Pair<String, Key>> getLastMessage() {
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList arrayList = ContainerUtil.newArrayList(this.myLastMessage);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorMainProcessHandler", "getLastMessage"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(ProcessEvent event, Key outputType) {
        Object object = this.myLock;
        synchronized (object) {
            while (this.myLastMessage.size() >= 300) {
                this.myLastMessage.pop();
            }
            this.myLastMessage.add((Pair<String, Key>)Pair.create((Object)event.getText(), (Object)outputType));
        }
    }

    public InetSocketAddress getSocketAddress() {
        return this.mySocketAddress;
    }

    public void setSocketAddress(InetSocketAddress socketAddress) {
        this.mySocketAddress = socketAddress;
    }

    protected void doDestroyProcess() {
        super.doDestroyProcess();
        if (SystemInfo.isWindows) {
            this.killProcess();
        }
    }
}

