/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfigurationBase;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.nodeJs.NodeJSDebuggableConfiguration;
import com.jetbrains.plugins.meteor.MeteorFacade;
import com.jetbrains.plugins.meteor.runner.MeteorFileFinder;
import com.jetbrains.plugins.meteor.runner.MeteorRunConfigurationEditor;
import com.jetbrains.plugins.meteor.runner.MeteorRunProfileState;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import java.net.InetSocketAddress;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorRunConfiguration
extends DebuggableProcessRunConfigurationBase
implements NodeJSDebuggableConfiguration,
DebuggableProcessRunConfiguration {
    private static final String STATE_TAG_NAME = "meteor-runner-state";
    @NotNull
    private MeteorState myState = new MeteorState();

    @NotNull
    public DebuggableFileFinder createFileFinder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "createFileFinder"));
        }
        MeteorFileFinder meteorFileFinder = new MeteorFileFinder(FileUtil.toSystemIndependentName((String)this.getEffectiveWorkingDirectory()));
        if (meteorFileFinder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "createFileFinder"));
        }
        return meteorFileFinder;
    }

    @Nullable
    protected String computeDefaultExePath() {
        return MeteorSettings.getInstance().getExecutablePath();
    }

    @NotNull
    protected String getInputFileTitle() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "getInputFileTitle"));
        }
        return "";
    }

    public String getExePath() {
        String path = super.getExePath();
        return path == null ? this.computeDefaultExePath() : path;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (socketAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socketAddress", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "createDebugProcess"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "createDebugProcess"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "createDebugProcess"));
        }
        XDebugProcess xDebugProcess = NodeDebugProgramRunnerKt.createNodeJsDebugProcess((InetSocketAddress)socketAddress, (XDebugSession)session, (ExecutionResult)executionResult, (DebuggableFileFinder)this.createFileFinder(session.getProject()));
        if (xDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "createDebugProcess"));
        }
        return xDebugProcess;
    }

    @NotNull
    public StartBrowserSettings getStartBrowserSettings() {
        if (this.myState.startBrowserSettings == null) {
            this.myState.startBrowserSettings = new StartBrowserSettings();
            this.myState.startBrowserSettings.setUrl("http://localhost:3000");
        }
        StartBrowserSettings startBrowserSettings = this.myState.startBrowserSettings;
        if (startBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "getStartBrowserSettings"));
        }
        return startBrowserSettings;
    }

    public void setStartBrowserSettings(StartBrowserSettings settings) {
        this.myState.startBrowserSettings = settings;
    }

    protected MeteorRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        MeteorRunConfigurationEditor meteorRunConfigurationEditor = new MeteorRunConfigurationEditor(this.getProject());
        if (meteorRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "getConfigurationEditor"));
        }
        return meteorRunConfigurationEditor;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/plugins/meteor/runner/MeteorRunConfiguration", "getState"));
        }
        return new MeteorRunProfileState(this, environment);
    }

    public void setWorkingDirectory(@Nullable String value) {
        String resultDir = StringUtil.equals((CharSequence)PathUtil.toSystemDependentName((String)this.getProject().getBasePath()), (CharSequence)PathUtil.toSystemDependentName((String)value)) ? null : value;
        super.setWorkingDirectory(resultDir);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myState = new MeteorState();
        Element stateElement = element.getChild(STATE_TAG_NAME);
        if (stateElement != null) {
            XmlSerializer.deserializeInto((Object)this.myState, (Element)stateElement);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.myState, (SerializationFilter)new SkipDefaultValuesSerializationFilters()));
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!MeteorFacade.getInstance().isMeteorFolder(this.getEffectiveWorkingDirectory())) {
            throw new RuntimeConfigurationError("Please specify path to meteor working directory correctly");
        }
    }

    @Tag(value="meteor-runner-state")
    private static class MeteorState {
        @Tag
        @Nullable
        public StartBrowserSettings startBrowserSettings;

        private MeteorState() {
        }
    }
}

