/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.ide.browsers.StartBrowserPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.PathUtil;
import com.jetbrains.plugins.meteor.MeteorBundle;
import com.jetbrains.plugins.meteor.MeteorUIUtil;
import com.jetbrains.plugins.meteor.runner.MeteorRunConfiguration;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MeteorRunConfigurationEditor
extends SettingsEditor<MeteorRunConfiguration> {
    private StartBrowserPanel myStartBrowserPanel;
    private MeteorDebuggableProgramParametersPanel myMeteorDebuggablePanel;
    private Project myProject;

    public MeteorRunConfigurationEditor(Project project) {
        this.myProject = project;
    }

    protected void resetEditorFrom(@NotNull MeteorRunConfiguration s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/plugins/meteor/runner/MeteorRunConfigurationEditor", "resetEditorFrom"));
        }
        this.myStartBrowserPanel.setFromSettings(s.getStartBrowserSettings());
        this.myMeteorDebuggablePanel.reset((CommonProgramRunConfigurationParameters)s);
    }

    protected void applyEditorTo(@NotNull MeteorRunConfiguration s) throws ConfigurationException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/plugins/meteor/runner/MeteorRunConfigurationEditor", "applyEditorTo"));
        }
        s.setStartBrowserSettings(this.myStartBrowserPanel.createSettings());
        this.myMeteorDebuggablePanel.applyTo((CommonProgramRunConfigurationParameters)s);
    }

    @NotNull
    protected JComponent createEditor() {
        this.myStartBrowserPanel = new StartBrowserPanel();
        this.myMeteorDebuggablePanel = new MeteorDebuggableProgramParametersPanel(this.myProject);
        JBTabbedPane mainPane = new JBTabbedPane();
        mainPane.addTab("Configuration", (Component)((Object)this.myMeteorDebuggablePanel));
        mainPane.addTab("Browser / Live Edit", (Component)this.myStartBrowserPanel.getComponent());
        mainPane.setSelectedIndex(0);
        JBTabbedPane jBTabbedPane = mainPane;
        if (jBTabbedPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorRunConfigurationEditor", "createEditor"));
        }
        return jBTabbedPane;
    }

    protected static class MeteorDebuggableProgramParametersPanel
    extends CommonProgramParametersPanel {
        private LabeledComponent<? extends JComponent> exePathComponent;
        private TextFieldWithHistoryWithBrowseButton exePathTextField;
        private Project myProject;

        public MeteorDebuggableProgramParametersPanel(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/runner/MeteorRunConfigurationEditor$MeteorDebuggableProgramParametersPanel", "<init>"));
            }
            super(false);
            this.myProject = project;
            this.init();
        }

        @NotNull
        protected Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/MeteorRunConfigurationEditor$MeteorDebuggableProgramParametersPanel", "getProject"));
            }
            return project;
        }

        protected void addComponents() {
            this.exePathTextField = MeteorUIUtil.createTextField(this.myProject);
            this.exePathComponent = LabeledComponent.create((JComponent)this.exePathTextField, (String)MeteorBundle.message("settings.meteor.configurable.executable", new Object[0]));
            this.exePathComponent.setLabelLocation("West");
            this.add((Component)this.exePathComponent);
            super.addComponents();
        }

        public void setAnchor(JComponent anchor) {
            super.setAnchor(anchor);
            this.exePathComponent.setAnchor(anchor);
        }

        public void applyTo(CommonProgramRunConfigurationParameters c) {
            super.applyTo(c);
            MeteorRunConfiguration configuration = (MeteorRunConfiguration)c;
            configuration.setExePath(this.exePathTextField.getText());
        }

        public void reset(CommonProgramRunConfigurationParameters c) {
            super.reset(c);
            MeteorRunConfiguration configuration = (MeteorRunConfiguration)c;
            MeteorUIUtil.setValue(configuration.getExePath(), this.exePathTextField);
            this.setWorkingDirectory(PathUtil.toSystemDependentName((String)configuration.getEffectiveWorkingDirectory()));
        }
    }
}

