/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.BrowserStarter;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.debugger.execution.DebuggableProcessState;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.jetbrains.plugins.meteor.runner.MeteorErrorFilter;
import com.jetbrains.plugins.meteor.runner.MeteorMainProcessHandler;
import com.jetbrains.plugins.meteor.runner.MeteorRunConfiguration;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/plugins/meteor/runner/MeteorRunProfileState;", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessState;", "Lcom/jetbrains/plugins/meteor/runner/MeteorRunConfiguration;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/jetbrains/plugins/meteor/runner/MeteorRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "addConsoleFilters", "", "builder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "configureCommandLine", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "debugPort", "", "createProcessHandler", "Lcom/jetbrains/plugins/meteor/runner/MeteorMainProcessHandler;", "getProcessHandler", "port", "Meteor"})
public final class MeteorRunProfileState
extends DebuggableProcessState<MeteorRunConfiguration> {
    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) {
        String parameters;
        CharSequence charSequence;
        MeteorSettings settings;
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        MeteorSettings meteorSettings = MeteorSettings.getInstance();
        if (meteorSettings == null) {
            Intrinsics.throwNpe();
        }
        if ((settings = meteorSettings).isStartOnce()) {
            commandLine.addParameter("--once");
        }
        if (!((charSequence = (CharSequence)(parameters = ((MeteorRunConfiguration)this.getConfiguration()).getProgramParameters())) == null || charSequence.length() == 0)) {
            String string = parameters;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String[] stringArray = ParametersList.parse((String)string);
            commandLine.addParameters(Arrays.copyOf(stringArray, stringArray.length));
        }
        if (debugPort != -1) {
            commandLine.getEnvironment().put("NODE_OPTIONS", "--debug-brk=" + debugPort);
        }
    }

    @NotNull
    protected MeteorMainProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        MeteorMainProcessHandler handler = new MeteorMainProcessHandler(commandLine);
        new BrowserStarter((RunConfiguration)this.getConfiguration(), ((MeteorRunConfiguration)this.getConfiguration()).getStartBrowserSettings(), (ProcessHandler)handler).start();
        return handler;
    }

    protected void addConsoleFilters(@NotNull TextConsoleBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        String workingDirectory = ((MeteorRunConfiguration)this.getConfiguration()).getEffectiveWorkingDirectory();
        builder.addFilter((Filter)new NodeConsoleAdditionalFilter(this.getEnvironment().getProject(), workingDirectory));
        builder.addFilter((Filter)new UrlFilter());
        builder.addFilter((Filter)new MeteorErrorFilter(this.getEnvironment().getProject(), workingDirectory));
    }

    @NotNull
    public final MeteorMainProcessHandler getProcessHandler(int port) {
        Object object = this.startProcess(new GeneralCommandLine(), port).blockingGet(0);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.plugins.meteor.runner.MeteorMainProcessHandler");
        }
        return (MeteorMainProcessHandler)((Object)object);
    }

    public MeteorRunProfileState(@NotNull MeteorRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        super((DebuggableProcessRunConfiguration)configuration, environment);
    }
}

