/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner.liveEdit;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.xdebugger.XDebugProcess;
import com.jetbrains.liveEdit.update.UpdateConfiguration;
import com.jetbrains.liveEdit.update.UpdateConfigurationProvider;
import com.jetbrains.plugins.meteor.runner.MeteorRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorUpdateConfigurationProvider
extends UpdateConfigurationProvider {
    private static final String S = "(function(Npm, Assets){(function(){";
    private static final String E = "\n})();\n\n})";
    private static final UpdateConfiguration UPDATE_CONFIGURATION = new UpdateConfiguration(){

        @NotNull
        public CharSequence preprocessSource(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/plugins/meteor/runner/liveEdit/MeteorUpdateConfigurationProvider$1", "preprocessSource"));
            }
            MergingCharSequence mergingCharSequence = new MergingCharSequence((CharSequence)new MergingCharSequence((CharSequence)MeteorUpdateConfigurationProvider.S, text), (CharSequence)MeteorUpdateConfigurationProvider.E);
            if (mergingCharSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/runner/liveEdit/MeteorUpdateConfigurationProvider$1", "preprocessSource"));
            }
            return mergingCharSequence;
        }
    };

    @Nullable
    public UpdateConfiguration getConfiguration(@NotNull XDebugProcess debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/plugins/meteor/runner/liveEdit/MeteorUpdateConfigurationProvider", "getConfiguration"));
        }
        boolean isMeteorProcess = debugProcess.getSession().getRunProfile() instanceof MeteorRunConfiguration;
        return isMeteorProcess ? UPDATE_CONFIGURATION : null;
    }

    public boolean isSupported(@NotNull RunProfile runProfile) {
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/jetbrains/plugins/meteor/runner/liveEdit/MeteorUpdateConfigurationProvider", "isSupported"));
        }
        return runProfile instanceof MeteorRunConfiguration;
    }
}

