/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.settings;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="MeteorSettings", storages={@Storage(value="meteorSettings.xml")})
public class MeteorSettings
implements PersistentStateComponent<MeteorSettings> {
    public static final String METEOR_SIMPLE_NAME = "meteor";
    private boolean isExcludeMeteorLocalFolder = true;
    private String executablePath;
    private boolean isWeakSearch = true;
    private boolean isStartOnce = false;
    private boolean isAutoImport = true;

    public boolean isAutoImport() {
        return this.isAutoImport;
    }

    public boolean isWeakSearch() {
        return this.isWeakSearch;
    }

    public void setIsWeakSearch(boolean isWeakSearch) {
        this.isWeakSearch = isWeakSearch;
    }

    public void setAutoImport(boolean autoImport) {
        this.isAutoImport = autoImport;
    }

    public static MeteorSettings getInstance() {
        return (MeteorSettings)ServiceManager.getService(MeteorSettings.class);
    }

    @Nullable
    public MeteorSettings getState() {
        return this;
    }

    public void loadState(MeteorSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public boolean isExcludeMeteorLocalFolder() {
        return this.isExcludeMeteorLocalFolder;
    }

    public void setExcludeMeteorLocalFolder(boolean isExcludeMeteorLocalFolder) {
        this.isExcludeMeteorLocalFolder = isExcludeMeteorLocalFolder;
    }

    public String getExecutablePath() {
        return StringUtil.isEmpty((String)this.executablePath) ? MeteorSettings.detectMeteorExecutablePath() : this.executablePath;
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public boolean isStartOnce() {
        return this.isStartOnce;
    }

    public void setStartOnce(boolean isStartOnce) {
        this.isStartOnce = isStartOnce;
    }

    @NotNull
    public static String detectMeteorExecutablePath() {
        List<String> strings = MeteorSettings.detectMeteorExecutablePaths();
        String string = strings.isEmpty() ? "" : (String)ContainerUtil.getFirstItem(strings);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/settings/MeteorSettings", "detectMeteorExecutablePath"));
        }
        return string;
    }

    @NotNull
    public static List<String> detectMeteorExecutablePaths() {
        ArrayList result = ContainerUtil.newArrayList();
        if (SystemInfo.isWindows) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)PathEnvironmentVariableUtil.findInPath((String)"meteor.bat"));
            ContainerUtil.addIfNotNull((Collection)result, (Object)PathEnvironmentVariableUtil.findInPath((String)"meteor.cmd"));
            ContainerUtil.addIfNotNull((Collection)result, (Object)PathEnvironmentVariableUtil.findInPath((String)"meteor.exe"));
        } else {
            ContainerUtil.addIfNotNull((Collection)result, (Object)PathEnvironmentVariableUtil.findInPath((String)METEOR_SIMPLE_NAME));
        }
        List list = ContainerUtil.map((Collection)result, file -> file.getAbsolutePath());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/settings/MeteorSettings", "detectMeteorExecutablePaths"));
        }
        return list;
    }
}

