/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.settings.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.meteor.MeteorBundle;
import com.jetbrains.plugins.meteor.MeteorFacade;
import com.jetbrains.plugins.meteor.MeteorUIUtil;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class MeteorConfigurable
implements Configurable,
Configurable.NoScroll {
    public static final String ID = "settings.javascript.meteor";
    private TextFieldWithHistoryWithBrowseButton myExecutablePathField;
    private JBCheckBox myExcludeMeteorLocalFolder;
    private JBCheckBox myStartOnce;
    private MeteorSettings mySettings;
    private Project myProject;
    private JBCheckBox myWeakSearchTemplate;
    private JBCheckBox myAutoImportPackage;

    public MeteorConfigurable(Project project) {
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return MeteorBundle.message("settings.meteor.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return ID;
    }

    @Nullable
    public JComponent createComponent() {
        this.mySettings = MeteorSettings.getInstance();
        this.myExecutablePathField = MeteorUIUtil.createTextField(this.myProject);
        this.myExcludeMeteorLocalFolder = new JBCheckBox(MeteorBundle.message("settings.meteor.configurable.exclude-local", new Object[0]));
        this.myStartOnce = new JBCheckBox(MeteorBundle.message("settings.meteor.configurable.disable.hot.push", new Object[0]));
        this.myAutoImportPackage = new JBCheckBox(MeteorBundle.message("settings.meteor.configurable.auto.import.packages", new Object[0]));
        this.myWeakSearchTemplate = new JBCheckBox(MeteorBundle.message("settings.meteor.configurable.weak.search.template", new Object[0]));
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addLabeledComponent(MeteorBundle.message("settings.meteor.configurable.executable", new Object[0]), (JComponent)this.myExecutablePathField);
        builder.addComponent((JComponent)this.myExcludeMeteorLocalFolder);
        builder.addComponent((JComponent)this.myStartOnce);
        builder.addComponent((JComponent)this.myAutoImportPackage);
        builder.addComponent((JComponent)this.myWeakSearchTemplate);
        if (!MeteorFacade.getInstance().isMeteorProject(this.myProject)) {
            JLabel viewer = new JLabel(MeteorBundle.message("settings.meteor.configurable.not.meteor.warning", new Object[0]), UIUtil.getBalloonWarningIcon(), 2);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)viewer);
            viewer.setBackground(MessageType.WARNING.getPopupBackground());
            builder.addComponent((JComponent)viewer);
        }
        JPanel panel = builder.getPanel();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)panel, "North");
        return wrapper;
    }

    public boolean isModified() {
        return !StringUtil.equals((CharSequence)this.myExecutablePathField.getText(), (CharSequence)this.mySettings.getExecutablePath()) || this.myExcludeMeteorLocalFolder.isSelected() != this.mySettings.isExcludeMeteorLocalFolder() || this.myWeakSearchTemplate.isSelected() != this.mySettings.isWeakSearch() || this.myAutoImportPackage.isSelected() != this.mySettings.isAutoImport() || this.myStartOnce.isSelected() == this.mySettings.isStartOnce();
    }

    public void apply() throws ConfigurationException {
        if (this.mySettings != null) {
            this.mySettings.setExecutablePath(this.myExecutablePathField.getText());
            this.mySettings.setExcludeMeteorLocalFolder(this.myExcludeMeteorLocalFolder.isSelected());
            this.mySettings.setStartOnce(!this.myStartOnce.isSelected());
            this.mySettings.setIsWeakSearch(this.myWeakSearchTemplate.isSelected());
            this.mySettings.setAutoImport(this.myAutoImportPackage.isSelected());
        }
    }

    public void reset() {
        if (this.mySettings != null) {
            ((TextFieldWithHistory)this.myExecutablePathField.getChildComponent()).setText(this.mySettings.getExecutablePath());
            ((TextFieldWithHistory)this.myExecutablePathField.getChildComponent()).addCurrentTextToHistory();
            this.myExcludeMeteorLocalFolder.setSelected(this.mySettings.isExcludeMeteorLocalFolder());
            this.myStartOnce.setSelected(!this.mySettings.isStartOnce());
            this.myWeakSearchTemplate.setSelected(this.mySettings.isWeakSearch());
            this.myAutoImportPackage.setSelected(this.mySettings.isAutoImport());
        }
    }

    public void disposeUIResources() {
    }
}

