/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.spacebars;

import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.dmarcotte.handlebars.psi.HbPsiFile;
import com.dmarcotte.handlebars.psi.impl.HbPsiElementImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.jetbrains.plugins.meteor.spacebars.lang.SpacebarsFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpacebarsUtils {
    @Nullable
    public static HbPsiElementImpl createMustacheTag(@NotNull Project project, @NotNull String name, boolean partial) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/spacebars/SpacebarsUtils", "createMustacheTag"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/plugins/meteor/spacebars/SpacebarsUtils", "createMustacheTag"));
        }
        HbPsiFile text = SpacebarsUtils.createFileFromText(project, "{{" + (partial ? ">" : "") + name + "}}");
        PsiElement statement = text.getFirstChild();
        if (statement == null) {
            return null;
        }
        PsiElement mustache = statement.getFirstChild();
        if (mustache == null) {
            return null;
        }
        ASTNode mustacheName = mustache.getNode().findChildByType(HbTokenTypes.MUSTACHE_NAME);
        if (mustacheName == null) {
            return null;
        }
        ASTNode path = mustacheName.findChildByType(HbTokenTypes.PATH);
        if (path == null) {
            return null;
        }
        ASTNode id = path.findChildByType(HbTokenTypes.ID);
        if (id == null) {
            return null;
        }
        return (HbPsiElementImpl)id.getPsi();
    }

    @NotNull
    private static HbPsiFile createFileFromText(Project project, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/plugins/meteor/spacebars/SpacebarsUtils", "createFileFromText"));
        }
        HbPsiFile hbPsiFile = (HbPsiFile)PsiFileFactory.getInstance((Project)project).createFileFromText("foo.spacebars", (FileType)SpacebarsFileType.SPACEBARS_INSTANCE, (CharSequence)text);
        if (hbPsiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/SpacebarsUtils", "createFileFromText"));
        }
        return hbPsiFile;
    }
}

