/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.spacebars.inspection;

import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.dmarcotte.handlebars.psi.impl.HbPsiElementImpl;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.meteor.MeteorBundle;
import com.jetbrains.plugins.meteor.spacebars.lang.SpacebarsLanguageDialect;
import com.jetbrains.plugins.meteor.spacebars.templates.helpers.MeteorMustacheTagPsiReference;
import com.jetbrains.plugins.meteor.spacebars.templates.helpers.MeteorSpacebarsReferenceContributor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MeteorUnresolvedSymbolInspection
extends LocalInspectionTool {
    public static final TokenSet OPEN_TOKENS = TokenSet.create((IElementType[])new IElementType[]{HbTokenTypes.OPEN, HbTokenTypes.OPEN_PARTIAL});
    private static final Set<String> ignoredParentTags = ContainerUtil.newHashSet((Object[])new String[]{"polymer-element"});
    public static final String THIS_KEYWORD = "this";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/plugins/meteor/spacebars/inspection/MeteorUnresolvedSymbolInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                PsiFile file = element.getContainingFile();
                if (file == null || !file.getLanguage().is((Language)SpacebarsLanguageDialect.INSTANCE)) {
                    super.visitElement(element);
                    return;
                }
                if (MeteorSpacebarsReferenceContributor.possibleMustacheBlockTag().accepts((Object)element) || MeteorSpacebarsReferenceContributor.possibleMustacheTag(OPEN_TOKENS).accepts((Object)element)) {
                    PsiReference[] references;
                    super.visitElement(element);
                    if (element instanceof HbPsiElementImpl && MeteorUnresolvedSymbolInspection.THIS_KEYWORD.equals(element.getText())) {
                        return;
                    }
                    for (PsiReference reference : references = element.getReferences()) {
                        if (!(reference instanceof MeteorMustacheTagPsiReference) || ((MeteorMustacheTagPsiReference)reference).multiResolve(false, true).length != 0 || MeteorUnresolvedSymbolInspection.hasIgnoredParentTag(element)) continue;
                        holder.registerProblem(element, MeteorBundle.message("meteor.inspection.unresolved", new Object[0]), new LocalQuickFix[0]);
                        return;
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/inspection/MeteorUnresolvedSymbolInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static boolean hasIgnoredParentTag(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/meteor/spacebars/inspection/MeteorUnresolvedSymbolInspection", "hasIgnoredParentTag"));
        }
        PsiElement place = MeteorMustacheTagPsiReference.getTagForPlace(element);
        if (place == null || place instanceof PsiFile) {
            return false;
        }
        XmlTag parent = (XmlTag)PsiTreeUtil.findFirstParent((PsiElement)place, element1 -> element1 instanceof XmlTag && ignoredParentTags.contains(((XmlTag)element1).getName()));
        return parent != null;
    }
}

