/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.spacebars.lang;

import com.dmarcotte.handlebars.file.HbLanguageSubstitutor;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.meteor.MeteorFacade;
import com.jetbrains.plugins.meteor.spacebars.lang.SpacebarsLanguageDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpacebarsLanguageSubstitutor
extends HbLanguageSubstitutor {
    public static final String METEOR_ANGULAR_EXTENSION = ".ng.html";

    @Nullable
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/meteor/spacebars/lang/SpacebarsLanguageSubstitutor", "getLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/spacebars/lang/SpacebarsLanguageSubstitutor", "getLanguage"));
        }
        Language language = super.getLanguage(file, project);
        if (null != language && MeteorFacade.getInstance().isMeteorProject(project)) {
            return file.getName().endsWith(METEOR_ANGULAR_EXTENSION) ? HTMLLanguage.INSTANCE : SpacebarsLanguageDialect.INSTANCE;
        }
        return language;
    }
}

