/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.spacebars.templates;

import com.dmarcotte.handlebars.psi.HbHash;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSCustomIndexer;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorHelpersFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    private static final String METHOD_REGISTER_TEMPLATE_HELPERS = "helpers";
    private static final String METHOD_REGISTER_GLOBAL_HELPER = "registerHelper";
    private static final String[] INTERESTED_METHOD_NAMES = new String[]{"registerHelper"};
    private static final Set<String> POSSIBLE_NAMESPACES_FOR_GLOBAL_HELPER_METHOD = ContainerUtil.newHashSet((Object[])new String[]{"Template", "Handlebars", "UI", "Blaze"});
    public static final String NAMESPACE_GLOBAL_HELPERS = "MeteorGlobalHelpersNamespace";
    public static final String NAMESPACE_TEMPLATE_HELPERS = "MeteorTemplateHelpersNamespace";
    public static final int INDEX_VERSION = 4;
    public static final String METEOR_TEMPLATE_JS_TYPE = "Template";
    public static final String METEOR_DEPRECATED_NAMESPACE_UI = "UI";
    public static final String METEOR_TEMPLATE_RESOLVED_TYPE = "ITemplate";
    public static final String METEOR_TEMPLATE_TAG = "template";
    public static final String HASH_NAMESPACE = "hash";

    public String resolveContextFromProperty(JSObjectLiteralExpression objectLiteralExpression, boolean returnPropertiesNamespace) {
        PsiElement argumentList = objectLiteralExpression.getParent();
        if (!(argumentList instanceof JSArgumentList)) {
            return null;
        }
        PsiElement callExpression = argumentList.getParent();
        if (!(callExpression instanceof JSCallExpression)) {
            return null;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return null;
        }
        if (!METHOD_REGISTER_TEMPLATE_HELPERS.equals(((JSReferenceExpression)methodExpression).getReferencedName())) {
            return null;
        }
        JSReferenceExpression withTemplateNameExpression = MeteorHelpersFrameworkIndexingHandler.getReferenceExpressionQualifier(methodExpression);
        if (withTemplateNameExpression == null) {
            return null;
        }
        JSReferenceExpression templateCallExpression = MeteorHelpersFrameworkIndexingHandler.getReferenceExpressionQualifier((JSExpression)withTemplateNameExpression);
        if (templateCallExpression == null) {
            return null;
        }
        if (!MeteorHelpersFrameworkIndexingHandler.checkTemplateReferenceExpression(templateCallExpression)) {
            return null;
        }
        return MeteorHelpersFrameworkIndexingHandler.getTemplateNamespace(withTemplateNameExpression.getReferencedName());
    }

    public static String getTemplateNamespace(String templateName) {
        return "MeteorTemplateHelpersNamespace." + templateName;
    }

    @NotNull
    public String[] interestedMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "interestedMethodNames"));
        }
        return INTERESTED_METHOD_NAMES;
    }

    public boolean processProperty(String name, @Nullable JSElement value, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "processProperty"));
        }
        return super.processProperty(name, value, outData);
    }

    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calledMethodName", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "createLiteralImplicitElementProvider"));
        }
        assert (METHOD_REGISTER_GLOBAL_HELPER.equals(calledMethodName));
        return new JSLiteralImplicitElementProvider(){

            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                if (argument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler$1", "fillIndexingData"));
                }
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler$1", "fillIndexingData"));
                }
                if (outIndexingData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler$1", "fillIndexingData"));
                }
                if (MeteorHelpersFrameworkIndexingHandler.hasGlobalHelpers(callExpression)) {
                    Object[] arguments = callExpression.getArguments();
                    if (arguments.length != 2) {
                        return;
                    }
                    JSExpression nameLiteral = (JSExpression)ArrayUtil.getFirstElement((Object[])arguments);
                    if (nameLiteral != argument) {
                        return;
                    }
                    if (argument.isQuotedLiteral()) {
                        String text = nameLiteral.getText();
                        if (StringUtil.isEmpty((String)text)) {
                            return;
                        }
                        String unquote = StringUtil.unquoteString((String)text);
                        if (StringUtil.isEmpty((String)unquote)) {
                            return;
                        }
                        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(unquote, (PsiElement)argument).setNamespace((JSQualifiedName)JSQualifiedNameImpl.create((String)MeteorHelpersFrameworkIndexingHandler.NAMESPACE_GLOBAL_HELPERS, null));
                        outIndexingData.addImplicitElement((JSImplicitElement)builder.toImplicitElement());
                    }
                }
            }
        };
    }

    public boolean processCustomElement(@NotNull PsiElement element, @NotNull JSIndexContentBuilder builder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "processCustomElement"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "processCustomElement"));
        }
        if (element instanceof XmlTag) {
            return MeteorHelpersFrameworkIndexingHandler.processTag((XmlTag)element, builder);
        }
        if (element instanceof HbHash) {
            return this.processSpacebarsHash((HbHash)element, builder);
        }
        return true;
    }

    private boolean processSpacebarsHash(@NotNull HbHash element, JSIndexContentBuilder builder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "processSpacebarsHash"));
        }
        String name = element.getHashName();
        if (StringUtil.isEmpty((String)name)) {
            return true;
        }
        PsiElement nameElement = element.getHashNameElement();
        assert (nameElement != null);
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(name, null);
        elementBuilder.setNamespace((JSQualifiedName)JSQualifiedNameImpl.create((String)HASH_NAMESPACE, null)).setNamespaceExplicitlyDeclared(false).setContext(JSContext.INSTANCE).setAccessType(JSAttributeList.AccessType.PUBLIC).setType(JSImplicitElement.Type.Property);
        JSImplicitElementsIndex.JSElementProxy proxy = new JSImplicitElementsIndex.JSElementProxy(elementBuilder, nameElement.getTextRange().getStartOffset());
        builder.addImplicitElement(name, proxy);
        return false;
    }

    private static boolean processTag(@NotNull XmlTag tag, @NotNull JSIndexContentBuilder builder) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "processTag"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "processTag"));
        }
        if (!METEOR_TEMPLATE_TAG.equals(tag.getName())) {
            return true;
        }
        XmlAttribute nameAttribute = tag.getAttribute("name");
        if (nameAttribute == null) {
            return true;
        }
        String value = nameAttribute.getValue();
        if (value == null) {
            return true;
        }
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(value, null).setNamespace((JSQualifiedName)JSQualifiedNameImpl.create((String)METEOR_TEMPLATE_RESOLVED_TYPE, null)).setNamespaceExplicitlyDeclared(false).setAccessType(JSAttributeList.AccessType.PUBLIC).setContext(JSContext.INSTANCE).setType(JSImplicitElement.Type.Tag);
        JSCustomIndexer.addImplicitElement((XmlAttribute)nameAttribute, (JSImplicitElementImpl.Builder)elementBuilder, (JSIndexContentBuilder)builder);
        return false;
    }

    public int getVersion() {
        return 4;
    }

    private static boolean hasGlobalHelpers(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "hasGlobalHelpers"));
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        if (!METHOD_REGISTER_GLOBAL_HELPER.equals(((JSReferenceExpression)methodExpression).getReferencedName())) {
            return false;
        }
        JSReferenceExpression withNamespaceQualifier = MeteorHelpersFrameworkIndexingHandler.getReferenceExpressionQualifier(methodExpression);
        return withNamespaceQualifier != null && POSSIBLE_NAMESPACES_FOR_GLOBAL_HELPER_METHOD.contains(withNamespaceQualifier.getReferencedName());
    }

    @Nullable
    private static JSReferenceExpression getReferenceExpressionQualifier(@Nullable JSExpression expression) {
        if (expression instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            return qualifier instanceof JSReferenceExpression ? (JSReferenceExpression)qualifier : null;
        }
        return null;
    }

    public static boolean isMeteorTemplateTypeExpression(JSExpression expression) {
        JSReferenceExpressionImpl type = (JSReferenceExpressionImpl)PsiTreeUtil.findChildOfType((PsiElement)expression, JSReferenceExpressionImpl.class);
        if (type == null) {
            return false;
        }
        return MeteorHelpersFrameworkIndexingHandler.checkTemplateReferenceExpression((JSReferenceExpression)type);
    }

    public boolean canProcessCustomElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "canProcessCustomElement"));
        }
        return element instanceof XmlTag || element instanceof HbHash;
    }

    public static boolean checkTemplateReferenceExpression(@NotNull JSReferenceExpression type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorHelpersFrameworkIndexingHandler", "checkTemplateReferenceExpression"));
        }
        String context = type.getReferencedName();
        if (context == null || type.getQualifier() != null) {
            return false;
        }
        return METEOR_TEMPLATE_JS_TYPE.equals(context) || METEOR_DEPRECATED_NAMESPACE_UI.equals(context);
    }
}

