/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.spacebars.templates;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.plugins.meteor.spacebars.lang.SpacebarsFileType;
import com.jetbrains.plugins.meteor.spacebars.lang.SpacebarsLanguageDialect;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MeteorTemplateIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> METEOR_TEMPLATES_INDEX = ID.create((String)"MeteorTemplateIndex");
    private static final int INDEX_VERSION = 2;
    public static final String TEMPLATE_TAG = "template";
    public static final String NAME_ATTRIBUTE = "name";

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = METEOR_TEMPLATES_INDEX;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorTemplateIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        MyDataIndexer myDataIndexer = new MyDataIndexer();
        if (myDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorTemplateIndex", "getIndexer"));
        }
        return myDataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorTemplateIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{HtmlFileType.INSTANCE, SpacebarsFileType.SPACEBARS_INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorTemplateIndex$1", "acceptInput"));
                }
                return super.acceptInput(file) && !(file.getFileSystem() instanceof JarFileSystem);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorTemplateIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public static ArrayList<PsiElement> findDeclarations(String key, PsiManager psiManager, GlobalSearchScope scope) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        FileBasedIndex.getInstance().getFilesWithKey(METEOR_TEMPLATES_INDEX, (Set)ContainerUtil.newHashSet((Object[])new String[]{key}), file -> {
            PsiFile psiFile = psiManager.findFile(file);
            MeteorTemplateIndex.visitTemplateTags(psiFile, (Consumer<XmlTag>)((Consumer)tag -> {
                XmlAttribute name = tag.getAttribute(NAME_ATTRIBUTE);
                if (name != null && key.equals(name.getValue())) {
                    result.add((PsiElement)name.getValueElement());
                }
            }));
            return false;
        }, scope);
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorTemplateIndex", "findDeclarations"));
        }
        return arrayList;
    }

    public static Collection<String> getKeys(Project project) {
        Collection keys = FileBasedIndex.getInstance().getAllKeys(METEOR_TEMPLATES_INDEX, project);
        return ContainerUtil.filter((Collection)keys, s -> {
            List values = FileBasedIndex.getInstance().getValues(METEOR_TEMPLATES_INDEX, s, GlobalSearchScope.allScope((Project)project));
            return !values.isEmpty();
        });
    }

    private static void visitTemplateTags(PsiFile psiFile, final Consumer<XmlTag> processor) {
        FileViewProvider viewProvider = psiFile.getViewProvider();
        PsiFile spacebarsFile = viewProvider.getPsi((Language)SpacebarsLanguageDialect.INSTANCE);
        if (spacebarsFile == null) {
            return;
        }
        PsiFile htmlPsiFile = viewProvider.getPsi((Language)HTMLLanguage.INSTANCE);
        if (htmlPsiFile == null) {
            return;
        }
        htmlPsiFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (MeteorTemplateIndex.TEMPLATE_TAG.equalsIgnoreCase(tag.getName())) {
                    processor.consume((Object)tag);
                    return;
                }
                super.visitXmlTag(tag);
            }
        });
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorTemplateIndex$MyDataIndexer", "map"));
            }
            THashMap result = new THashMap();
            MeteorTemplateIndex.visitTemplateTags(inputData.getPsiFile(), (Consumer<XmlTag>)arg_0 -> MyDataIndexer.lambda$map$0((Map)result, arg_0));
            THashMap tHashMap = result;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/MeteorTemplateIndex$MyDataIndexer", "map"));
            }
            return tHashMap;
        }

        private static /* synthetic */ void lambda$map$0(Map result, XmlTag tag) {
            String name = tag.getAttributeValue(MeteorTemplateIndex.NAME_ATTRIBUTE);
            if (name != null) {
                result.put(name, null);
            }
        }
    }
}

