/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.spacebars.templates.helpers;

import com.dmarcotte.handlebars.psi.impl.HbPsiElementImpl;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.meteor.settings.MeteorSettings;
import com.jetbrains.plugins.meteor.spacebars.SpacebarsUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorMustacheTagPsiReference
extends PsiPolyVariantReferenceBase<HbPsiElementImpl> {
    public static final String BODY_DEFAULT_TEMPLATE = "body";
    protected final String myName;

    MeteorMustacheTagPsiReference(HbPsiElementImpl item, String name) {
        super((PsiElement)item, ElementManipulators.getValueTextRange((PsiElement)item), true);
        this.myName = name;
    }

    public boolean isReferenceTo(PsiElement element) {
        JSExpression qualifier;
        PsiElement resolve;
        JSExpression expression;
        if (element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression && StringUtil.equals((CharSequence)((JSReferenceExpression)expression).getReferenceName(), (CharSequence)this.myName) && (resolve = this.resolve()) != null && resolve instanceof JSQualifiedNamedElement && (qualifier = ((JSReferenceExpression)expression).getQualifier()) != null) {
            return StringUtil.equals((CharSequence)expression.getText(), (CharSequence)((JSQualifiedNamedElement)resolve).getQualifiedName());
        }
        return super.isReferenceTo(element);
    }

    @Nullable
    public static String getTemplateName(PsiElement myElement) {
        if (!myElement.isValid()) {
            return null;
        }
        PsiElement parent = MeteorMustacheTagPsiReference.getTagForPlace(myElement);
        if (parent == null) {
            return null;
        }
        XmlTag templateTag = (XmlTag)PsiTreeUtil.findFirstParent((PsiElement)parent, element -> element instanceof XmlTag && (((XmlTag)element).getName().equals("template") || ((XmlTag)element).getName().equals(BODY_DEFAULT_TEMPLATE)));
        if (templateTag == null) {
            return null;
        }
        if (templateTag.getName().equals(BODY_DEFAULT_TEMPLATE)) {
            return BODY_DEFAULT_TEMPLATE;
        }
        XmlAttribute name = templateTag.getAttribute("name");
        if (name == null) {
            return null;
        }
        return name.getValue();
    }

    @Nullable
    public static PsiElement getTagForPlace(PsiElement myElement) {
        PsiFile file = myElement.getContainingFile();
        if (file == null) {
            return null;
        }
        FileViewProvider provider = file.getViewProvider();
        if (!(provider instanceof TemplateLanguageFileViewProvider)) {
            return null;
        }
        TemplateLanguageFileViewProvider templateLanguageFileViewProvider = (TemplateLanguageFileViewProvider)provider;
        PsiElement elementAsHtml = templateLanguageFileViewProvider.findElementAt(myElement.getTextOffset(), templateLanguageFileViewProvider.getTemplateDataLanguage());
        if (elementAsHtml == null) {
            return null;
        }
        PsiElement parent = elementAsHtml.getParent();
        if (parent == null) {
            return null;
        }
        return parent;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static boolean isGlobalHelperQualifier(@Nullable JSPsiElementBase navigationItem) {
        if (navigationItem == null || navigationItem.getQualifiedName() == null) {
            return false;
        }
        return navigationItem.getQualifiedName().startsWith("MeteorGlobalHelpersNamespace.");
    }

    private static boolean isTemplateQualifier(@Nullable JSPsiElementBase navigationItem, @NotNull String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "isTemplateQualifier"));
        }
        if (navigationItem == null || navigationItem.getQualifiedName() == null) {
            return false;
        }
        String qualifiedName = navigationItem.getQualifiedName();
        return qualifiedName.startsWith("Template." + templateName + ".") || qualifiedName.startsWith("MeteorTemplateHelpersNamespace." + templateName + ".");
    }

    protected final PsiElement handleElementRename(String newElementName, boolean partial) throws IncorrectOperationException {
        HbPsiElementImpl newElement = SpacebarsUtils.createMustacheTag(((HbPsiElementImpl)this.myElement).getProject(), newElementName, partial);
        if (null == newElement) {
            throw new IncorrectOperationException("Incorrect name");
        }
        return ((HbPsiElementImpl)this.getElement()).replace((PsiElement)newElement);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.handleElementRename(newElementName, false);
    }

    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = this.multiResolve(incompleteCode, MeteorSettings.getInstance().isWeakSearch());
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode, boolean includeWeak) {
        List items;
        if (incompleteCode) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Collection allPossibleHelpers = JSClassResolver.getInstance().findElementsByNameIncludingImplicit(this.myName, ProjectScope.getAllScope((Project)((HbPsiElementImpl)this.getElement()).getProject()));
        if (allPossibleHelpers.size() == 0) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String templateName = MeteorMustacheTagPsiReference.getTemplateName(this.myElement);
        if (templateName != null && (items = ContainerUtil.findAll((Collection)allPossibleHelpers, item -> MeteorMustacheTagPsiReference.isTemplateQualifier(item, templateName))).size() > 0) {
            ResolveResult[] resolveResultArray = this.convertToResolveResult(items);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        items = ContainerUtil.findAll((Collection)allPossibleHelpers, item -> MeteorMustacheTagPsiReference.isGlobalHelperQualifier(item));
        if (items.size() > 0) {
            ResolveResult[] resolveResultArray = this.convertToResolveResult(items);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        if (includeWeak) {
            ResolveResult[] resolveResultArray = this.convertToResolveResult(allPossibleHelpers);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "multiResolve"));
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @NotNull
    public ResolveResult[] convertToResolveResult(Collection<JSPsiElementBase> items) {
        ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array(items, ResolveResult.class, item -> new JSResolveResult((PsiElement)item));
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorMustacheTagPsiReference", "convertToResolveResult"));
        }
        return resolveResultArray;
    }
}

