/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.spacebars.templates.helpers;

import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.dmarcotte.handlebars.psi.HbHash;
import com.dmarcotte.handlebars.psi.HbMustacheName;
import com.dmarcotte.handlebars.psi.impl.HbOpenBlockMustacheImpl;
import com.dmarcotte.handlebars.psi.impl.HbPartialImpl;
import com.dmarcotte.handlebars.psi.impl.HbPathImpl;
import com.dmarcotte.handlebars.psi.impl.HbPsiElementImpl;
import com.dmarcotte.handlebars.psi.impl.HbSimpleMustacheImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.meteor.spacebars.lang.SpacebarsLanguageDialect;
import com.jetbrains.plugins.meteor.spacebars.templates.helpers.MeteorMustachePartialTagPsiReference;
import com.jetbrains.plugins.meteor.spacebars.templates.helpers.MeteorMustacheTagPsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorSpacebarsReferenceContributor
extends PsiReferenceContributor {
    private static final PsiReference[] EMPTY_RESULT = PsiReference.EMPTY_ARRAY;
    public static final TokenSet OPEN_TOKEN = TokenSet.create((IElementType[])new IElementType[]{HbTokenTypes.OPEN, HbTokenTypes.OPEN_UNESCAPED});
    public static final TokenSet OPEN_PART_TOKEN = TokenSet.create((IElementType[])new IElementType[]{HbTokenTypes.OPEN_PARTIAL});

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorSpacebarsReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(MeteorSpacebarsReferenceContributor.possibleMustacheTag(OPEN_TOKEN), (PsiReferenceProvider)new SpacebarsTagPsiReferenceProvider(TagTypes.TAG));
        registrar.registerReferenceProvider(MeteorSpacebarsReferenceContributor.possibleMustacheTag(OPEN_PART_TOKEN), (PsiReferenceProvider)new SpacebarsTagPsiReferenceProvider(TagTypes.PARTIAL_TAG));
        registrar.registerReferenceProvider(MeteorSpacebarsReferenceContributor.possibleMustacheBlockTag(), (PsiReferenceProvider)new SpacebarsTagPsiReferenceProvider(TagTypes.BLOCK_TAG));
    }

    public static PsiElementPattern.Capture<HbPsiElementImpl> possibleMustacheBlockTag() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(HbPsiElementImpl.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                return this.isAcceptWithOpenToken(element);
            }

            public boolean isAcceptWithOpenToken(Object element) {
                return MeteorSpacebarsReferenceContributor.isAcceptBlockTag(element);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static boolean isAcceptBlockTag(Object element) {
        HbPsiElementImpl hbElement = (HbPsiElementImpl)element;
        PsiElement parentElement = hbElement.getParent();
        if (!(parentElement instanceof HbPathImpl)) {
            return false;
        }
        if (!((parentElement = parentElement.getParent()) instanceof HbMustacheName)) {
            return false;
        }
        PsiFile file = hbElement.getContainingFile();
        if (file == null) {
            return false;
        }
        Language language = file.getLanguage();
        if (!language.isKindOf((Language)SpacebarsLanguageDialect.INSTANCE)) {
            return false;
        }
        PsiElement blockWrapper = PsiTreeUtil.getParentOfType((PsiElement)parentElement, (Class[])new Class[]{HbOpenBlockMustacheImpl.class, HbHash.class});
        if (blockWrapper == null || blockWrapper instanceof HbHash) {
            return false;
        }
        if (blockWrapper.getFirstChild().getNode().getElementType() != HbTokenTypes.OPEN_BLOCK) {
            return false;
        }
        PsiElement firstParam = (PsiElement)ContainerUtil.find((Object[])blockWrapper.getChildren(), element1 -> element1.getNode().getElementType() == HbTokenTypes.PARAM);
        return firstParam != null && firstParam.equals(parentElement.getParent());
    }

    public static PsiElementPattern.Capture<HbPsiElementImpl> possibleMustacheTag(final TokenSet openToken) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(HbPsiElementImpl.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                return MeteorSpacebarsReferenceContributor.isAcceptTag(element, openToken);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    public static boolean isAcceptTag(Object element, TokenSet openToken) {
        HbPsiElementImpl hbElement = (HbPsiElementImpl)element;
        PsiElement parentElement = hbElement.getParent();
        if (!(parentElement instanceof HbPathImpl)) {
            return false;
        }
        PsiFile file = hbElement.getContainingFile();
        if (file == null) {
            return false;
        }
        Language language = file.getLanguage();
        if (!language.isKindOf((Language)SpacebarsLanguageDialect.INSTANCE)) {
            return false;
        }
        if (parentElement.getFirstChild() != hbElement) {
            return false;
        }
        PsiElement mustacheParent = PsiTreeUtil.getParentOfType((PsiElement)parentElement, (Class[])new Class[]{HbSimpleMustacheImpl.class, HbPartialImpl.class, HbHash.class});
        if (mustacheParent == null || mustacheParent instanceof HbHash) {
            return false;
        }
        return openToken.contains(mustacheParent.getFirstChild().getNode().getElementType());
    }

    private static class SpacebarsTagPsiReferenceProvider
    extends PsiReferenceProvider {
        private final TagTypes myTagTypes;

        private SpacebarsTagPsiReferenceProvider(TagTypes tagTypes) {
            this.myTagTypes = tagTypes;
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorSpacebarsReferenceContributor$SpacebarsTagPsiReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorSpacebarsReferenceContributor$SpacebarsTagPsiReferenceProvider", "getReferencesByElement"));
            }
            HbPsiElementImpl hbElement = (HbPsiElementImpl)element;
            String propertyName = hbElement.getText();
            if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
                PsiReference[] psiReferenceArray = EMPTY_RESULT;
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorSpacebarsReferenceContributor$SpacebarsTagPsiReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
            switch (this.myTagTypes) {
                case TAG: {
                    PsiReference[] psiReferenceArray = SpacebarsTagPsiReferenceProvider.wrap((PsiReference)new MeteorMustacheTagPsiReference(hbElement, propertyName));
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorSpacebarsReferenceContributor$SpacebarsTagPsiReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                case PARTIAL_TAG: {
                    PsiReference[] psiReferenceArray = SpacebarsTagPsiReferenceProvider.wrap((PsiReference)new MeteorMustachePartialTagPsiReference(hbElement, propertyName));
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorSpacebarsReferenceContributor$SpacebarsTagPsiReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                case BLOCK_TAG: {
                    PsiReference[] psiReferenceArray = SpacebarsTagPsiReferenceProvider.wrap((PsiReference)new MeteorMustacheTagPsiReference(hbElement, propertyName));
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorSpacebarsReferenceContributor$SpacebarsTagPsiReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/spacebars/templates/helpers/MeteorSpacebarsReferenceContributor$SpacebarsTagPsiReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static PsiReference[] wrap(PsiReference ref) {
            return new PsiReference[]{ref};
        }
    }

    private static enum TagTypes {
        TAG,
        PARTIAL_TAG,
        BLOCK_TAG;

    }
}

