/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.tsStubs;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MeteorStubPath {
    public static final String EXTENSION = ".d.ts";

    @NotNull
    public static VirtualFile getLasMeteorLib() {
        List wrappers = ContainerUtil.map(MeteorStubPath.getFiles(), file -> new VFWrapper((VirtualFile)file));
        Collections.sort(wrappers);
        VFWrapper lastLib = (VFWrapper)ContainerUtil.getLastItem((List)wrappers);
        assert (lastLib != null);
        VirtualFile virtualFile = lastLib.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/meteor/tsStubs/MeteorStubPath", "getLasMeteorLib"));
        }
        return virtualFile;
    }

    private static List<VirtualFile> getFiles() {
        VirtualFile filesDir = MeteorStubPath.getStubDir();
        return ContainerUtil.filter((Object[])filesDir.getChildren(), file -> file.getName().endsWith(EXTENSION));
    }

    public static VirtualFile getStubDir() {
        URL resource = ResourceUtil.getResource(MeteorStubPath.class, (String)"tsMeteorStubs", (String)"");
        assert (resource != null);
        return VfsUtil.findFileByURL((URL)resource);
    }

    static class VersionNumber
    implements Comparable<VersionNumber> {
        List<Integer> myOrderedVersions;
        String myFileName;

        public VersionNumber(@NotNull String fileName) {
            String[] versionArray;
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/plugins/meteor/tsStubs/MeteorStubPath$VersionNumber", "<init>"));
            }
            this.myOrderedVersions = new ArrayList<Integer>();
            this.myFileName = fileName;
            String versionString = fileName.substring(fileName.indexOf(45) + 2, fileName.lastIndexOf(MeteorStubPath.EXTENSION));
            for (String s : versionArray = versionString.split("\\.")) {
                this.myOrderedVersions.add(Integer.valueOf(s));
            }
        }

        @Override
        public int compareTo(@NotNull VersionNumber o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/plugins/meteor/tsStubs/MeteorStubPath$VersionNumber", "compareTo"));
            }
            int size1 = this.myOrderedVersions.size();
            int size2 = o.myOrderedVersions.size();
            for (int index = 0; index < size2 && index < size1; ++index) {
                Integer v2;
                Integer v1 = this.myOrderedVersions.get(index);
                int compare = v1.compareTo(v2 = o.myOrderedVersions.get(index));
                if (compare == 0) continue;
                return compare;
            }
            return Integer.valueOf(size1).compareTo(size2);
        }
    }

    static class VFWrapper
    implements Comparable<VFWrapper> {
        private VirtualFile myFile;
        private VersionNumber myFileVersion;

        public VFWrapper(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/meteor/tsStubs/MeteorStubPath$VFWrapper", "<init>"));
            }
            this.myFile = file;
            this.myFileVersion = new VersionNumber(file.getName());
        }

        @Override
        public int compareTo(@NotNull VFWrapper o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/plugins/meteor/tsStubs/MeteorStubPath$VFWrapper", "compareTo"));
            }
            return this.myFileVersion.compareTo(o.myFileVersion);
        }
    }
}

