/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IConnectionStreams;
import org.netbeans.lib.cvsclient.io.StreamUtilities;
import org.netbeans.lib.cvsclient.response.IResponseHandler;
import org.netbeans.lib.cvsclient.response.IResponseServices;
import org.netbeans.lib.cvsclient.response.ResponseUtils;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class ResponseParser {
    private final IResponseHandler responseProcessor;
    private final StreamUtilities myStreamUtilities;
    @NonNls
    public static final String PREFIX_TO_REMOVE = "-f ";

    public ResponseParser(IResponseHandler responseProcessor, String charset) {
        BugLog.getInstance().assertNotNull(responseProcessor);
        BugLog.getInstance().assertNotNull(charset);
        this.responseProcessor = responseProcessor;
        this.myStreamUtilities = new StreamUtilities(charset);
    }

    public Boolean processResponse(String responseName, IConnectionStreams connectionStreams, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        InputStream loggedInputStream = connectionStreams.getLoggedInputStream();
        if (responseName.equalsIgnoreCase("E")) {
            byte[] line = StreamUtilities.readLineBytes(loggedInputStream);
            this.responseProcessor.processErrorMessageResponse(ResponseParser.prepareMessageAccordingToScr39148(line), responseServices);
            return null;
        }
        if (responseName.equalsIgnoreCase("M")) {
            byte[] line = StreamUtilities.readLineBytes(loggedInputStream);
            this.responseProcessor.processMessageResponse(ResponseParser.prepareMessageAccordingToScr39148(line), responseServices);
            return null;
        }
        if (responseName.equalsIgnoreCase("MBinary")) {
            String fileLengthString = this.myStreamUtilities.readLine(loggedInputStream);
            try {
                int fileLength = Integer.parseInt(fileLengthString);
                this.responseProcessor.processBinaryMessageResponse(fileLength, ResponseParser.readFromStream(connectionStreams, fileLength), responseServices);
            }
            catch (NumberFormatException fileLength) {
                // empty catch block
            }
            return null;
        }
        if (responseName.equalsIgnoreCase("MT")) {
            byte[] text = StreamUtilities.readLineBytes(loggedInputStream);
            this.responseProcessor.processMessageTaggedResponse(text, responseServices);
            return null;
        }
        if (responseName.equalsIgnoreCase("Updated")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            String entryLine = this.myStreamUtilities.readLine(loggedInputStream);
            String mode = this.myStreamUtilities.readLine(loggedInputStream);
            String fileLengthString = this.myStreamUtilities.readLine(loggedInputStream);
            try {
                int fileLength = Integer.parseInt(fileLengthString);
                this.responseProcessor.processUpdatedResponse(relativeLocalDirectory, repositoryFilePath, entryLine, mode, fileLength, clientEnvironment, responseServices, connectionStreams);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
        if (responseName.equalsIgnoreCase("Merged")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            String entryLine = this.myStreamUtilities.readLine(loggedInputStream);
            String mode = this.myStreamUtilities.readLine(loggedInputStream);
            String fileLengthString = this.myStreamUtilities.readLine(loggedInputStream);
            try {
                int fileLength = Integer.parseInt(fileLengthString);
                this.responseProcessor.processMergedResponse(relativeLocalDirectory, repositoryFilePath, entryLine, mode, fileLength, clientEnvironment, responseServices, connectionStreams);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
        if (responseName.equalsIgnoreCase("Checked-in")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            String entryLine = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processCheckedInResponse(relativeLocalDirectory, repositoryFilePath, entryLine, responseServices, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("New-entry")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            String entryLine = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processNewEntryResponse(relativeLocalDirectory, repositoryFilePath, responseServices, entryLine, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("Set-static-directory")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processSetStaticDirectoryResponse(relativeLocalDirectory, repositoryFilePath, responseServices, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("Clear-static-directory")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryDirectoryPath = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processClearStaticDirectoryResponse(relativeLocalDirectory, repositoryDirectoryPath, responseServices, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("Set-sticky")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            String tag = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processSetStickyResponse(relativeLocalDirectory, repositoryFilePath, tag, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("Clear-sticky")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processClearStickyResponse(relativeLocalDirectory, repositoryFilePath, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("Notified")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processNotifiedResponse(relativeLocalDirectory, repositoryFilePath, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("Removed")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFileName = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processRemovedResponse(relativeLocalDirectory, repositoryFileName, responseServices, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("Remove-entry")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processRemoveEntryResponse(relativeLocalDirectory, repositoryFilePath, responseServices, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("Copy-file")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            String newName = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processCopyFileResponse(relativeLocalDirectory, repositoryFilePath, newName, clientEnvironment);
            return null;
        }
        if (responseName.equalsIgnoreCase("Mod-time")) {
            String dateString = this.myStreamUtilities.readLine(loggedInputStream);
            try {
                Date modifiedDate = ResponseUtils.parseDateString(dateString);
                this.responseProcessor.processModTimeResponse(modifiedDate, responseServices);
            }
            catch (Exception ex) {
                BugLog.getInstance().showException(ex);
            }
            return null;
        }
        if (responseName.equalsIgnoreCase("Mode")) {
            String mode = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processModeResponse(mode, responseServices);
            return null;
        }
        if (responseName.equalsIgnoreCase("Template")) {
            String relativeLocalDirectory = this.myStreamUtilities.readLine(loggedInputStream);
            String repositoryFilePath = this.myStreamUtilities.readLine(loggedInputStream);
            String lengthString = this.myStreamUtilities.readLine(loggedInputStream);
            try {
                int length = Integer.parseInt(lengthString);
                this.responseProcessor.processTemplateResponse(relativeLocalDirectory, repositoryFilePath, length, clientEnvironment, connectionStreams);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
        if (responseName.equalsIgnoreCase("Module-expansion")) {
            String localPath = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processModuleExpansionResponse(localPath, responseServices);
            return null;
        }
        if (responseName.equalsIgnoreCase("ok")) {
            this.responseProcessor.processOkResponse(responseServices);
            return Boolean.TRUE;
        }
        if (responseName.equalsIgnoreCase("error")) {
            byte[] message = StreamUtilities.readLineBytes(loggedInputStream);
            this.responseProcessor.processErrorResponse(message, responseServices);
            return Boolean.FALSE;
        }
        if (responseName.equals("EntriesExtra")) {
            StreamUtilities.readLineBytes(loggedInputStream);
            return null;
        }
        if (responseName.equalsIgnoreCase("Valid-requests")) {
            String validRequests = this.myStreamUtilities.readLine(loggedInputStream);
            this.responseProcessor.processValidRequestsResponse(validRequests, responseServices);
            return null;
        }
        throw new IOException("Unhandled response: " + responseName + ".");
    }

    private static byte[] readFromStream(IConnectionStreams connectionStreams, int fileLength) throws IOException {
        byte[] buffer = new byte[fileLength];
        for (int read = 0; read < fileLength; read += connectionStreams.getInputStream().read(buffer, read, fileLength - read)) {
        }
        return buffer;
    }

    private static byte[] prepareMessageAccordingToScr39148(byte[] line) {
        if (line.length < 3) {
            return line;
        }
        if (ResponseParser.startsWith(PREFIX_TO_REMOVE, line)) {
            byte[] result = new byte[line.length - 3];
            System.arraycopy(line, 3, result, 0, result.length);
            return result;
        }
        return line;
    }

    private static boolean startsWith(String s, byte[] line) {
        for (int i = 0; i < s.length(); ++i) {
            if (line[i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

