/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import org.jetbrains.annotations.NotNull;

public class ProjectDeploymentRevisionTracker
extends DeploymentRevisionTrackerBase {
    public ProjectDeploymentRevisionTracker(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ProjectDeploymentRevisionTracker", "<init>"));
        }
        super(project, project.getName(), ProjectDeploymentRevisionTracker.getProjectPathForTracker(project));
        project.getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void optionsChanged() {
                if (PublishConfig.getInstance(project).getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.NONE) {
                    ProjectDeploymentRevisionTracker.this.closeMap();
                    ProjectDeploymentRevisionTracker.this.clearFiles();
                }
            }
        });
    }

    private static String getProjectPathForTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ProjectDeploymentRevisionTracker", "getProjectPathForTracker"));
        }
        if (project.isDefault()) {
            throw new IllegalStateException("ProjectDeploymentRevisionTracker is non-default project service.");
        }
        String baseDir = project.getBasePath();
        if (baseDir == null) {
            throw new IllegalStateException("Non-default project with null base directory");
        }
        return baseDir;
    }

    public static DeploymentRevisionTracker getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ProjectDeploymentRevisionTracker", "getInstance"));
        }
        return (DeploymentRevisionTracker)project.getComponent(DeploymentRevisionTracker.class);
    }
}

