/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.BeforeRunTask;
import com.jetbrains.plugins.webDeployment.UploadBeforeRunTaskProvider;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class UploadBeforeRunTask
extends BeforeRunTask<UploadBeforeRunTask> {
    private static final String SERVER_ID = "server_id";
    private static final String SERVER_NAME = "server_name";
    private static final String PATH = "path";
    private String myServerId;
    private String myServerName;
    private final List<String> myRoots = new ArrayList<String>();

    public UploadBeforeRunTask() {
        super(UploadBeforeRunTaskProvider.ID);
    }

    public void writeExternal(Element element) {
        super.writeExternal(element);
        Element serverIdChild = new Element(SERVER_ID);
        serverIdChild.addContent(this.myServerId);
        element.addContent(serverIdChild);
        Element serverNameChild = new Element(SERVER_NAME);
        serverNameChild.addContent(this.myServerName);
        element.addContent(serverNameChild);
        for (String root : this.myRoots) {
            Element child = new Element(PATH);
            child.addContent(root);
            element.addContent(child);
        }
    }

    public void readExternal(Element element) {
        Element serverNameChild;
        super.readExternal(element);
        this.myRoots.clear();
        for (Object o : element.getChildren(PATH)) {
            this.myRoots.add(((Element)o).getText());
        }
        Element serverIdChild = element.getChild(SERVER_ID);
        if (serverIdChild != null) {
            this.myServerId = serverIdChild.getText();
        }
        if ((serverNameChild = element.getChild(SERVER_NAME)) != null) {
            this.myServerName = serverNameChild.getText();
        }
    }

    public List<String> getRoots() {
        return this.myRoots;
    }

    public String getServerId() {
        return this.myServerId;
    }

    public String getServerName() {
        return this.myServerName;
    }

    public void setServerId(String serverId) {
        this.myServerId = serverId;
    }

    public void setServerName(String serverName) {
        this.myServerName = serverName;
    }
}

